/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.reactionsandrates.modules;

import edu.colorado.phet.common.phetcommon.model.Resettable;
import edu.colorado.phet.common.phetcommon.view.ResetAllButton;
import edu.colorado.phet.reactionsandrates.MRConfig;
import edu.colorado.phet.reactionsandrates.model.MRModel;
import edu.colorado.phet.reactionsandrates.modules.ComplexModule;
import edu.colorado.phet.reactionsandrates.modules.MRControlPanel;
import edu.colorado.phet.reactionsandrates.util.ControlBorderFactory;
import edu.colorado.phet.reactionsandrates.view.InitialTemperaturePanel;
import edu.colorado.phet.reactionsandrates.view.MoleculeInstanceControlPanel;
import edu.colorado.phet.reactionsandrates.view.ReactionChooserComboBox;
import edu.colorado.phet.reactionsandrates.view.charts.ChartOptionsPanel;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class ComplexMRControlPanel
extends MRControlPanel {
    private MoleculeInstanceControlPanel moleculeInstanceControlPanel;
    private ChartOptionsPanel optionsPanel;
    private static InitialTemperaturePanel initialTemperaturePanel;

    public ComplexMRControlPanel(final ComplexModule complexModule) {
        super(new GridBagLayout());
        MRModel mRModel = (MRModel)complexModule.getModel();
        GridBagConstraints gridBagConstraints = new GridBagConstraints(0, -1, 1, 1, 1.0, 1.0, 11, 0, new Insets(5, 0, 0, 0), 0, 0);
        JPanel jPanel = ComplexMRControlPanel.createReactionSelectionPanel(complexModule);
        this.moleculeInstanceControlPanel = new MoleculeInstanceControlPanel(mRModel, complexModule.getClock());
        this.optionsPanel = new ChartOptionsPanel(complexModule);
        ResetAllButton resetAllButton = new ResetAllButton(this);
        resetAllButton.addResettable(new Resettable(){

            public void reset() {
                complexModule.reset();
            }
        });
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        this.add((Component)jPanel, gridBagConstraints);
        gridBagConstraints.anchor = 10;
        this.add((Component)this.moleculeInstanceControlPanel, gridBagConstraints);
        this.add((Component)this.optionsPanel, gridBagConstraints);
        gridBagConstraints.fill = 0;
        this.add((Component)resetAllButton, gridBagConstraints);
    }

    private static JPanel createReactionSelectionPanel(ComplexModule complexModule) {
        JPanel jPanel = new JPanel(new GridBagLayout());
        jPanel.setBorder(ControlBorderFactory.createPrimaryBorder(MRConfig.RESOURCES.getLocalizedString("Control.initialConditions")));
        GridBagConstraints gridBagConstraints = new GridBagConstraints(0, -1, 1, 1, 1.0, 1.0, 17, 0, new Insets(2, 3, 3, 3), 0, 0);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridwidth = 4;
        gridBagConstraints.anchor = 17;
        jPanel.add((Component)new JLabel(MRConfig.RESOURCES.getLocalizedString("Control.selectReaction")), gridBagConstraints);
        gridBagConstraints.anchor = 10;
        jPanel.add((Component)new ReactionChooserComboBox(complexModule), gridBagConstraints);
        gridBagConstraints.anchor = 10;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = -1;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.gridheight = 0;
        initialTemperaturePanel = new InitialTemperaturePanel(complexModule);
        jPanel.add((Component)initialTemperaturePanel, gridBagConstraints);
        return jPanel;
    }

    public void reset() {
        initialTemperaturePanel.reset();
        this.optionsPanel.reset();
    }

    public boolean isTemperatureBeingAdjusted() {
        boolean bl = super.isTemperatureBeingAdjusted();
        if (!bl) {
            bl = initialTemperaturePanel.isTemperatureBeingAdjusted();
        }
        return bl;
    }
}

