/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.reactionsandrates.model.collision;

import edu.colorado.phet.common.mechanics.Body;
import edu.colorado.phet.common.phetcommon.math.vector.MutableVector2D;
import edu.colorado.phet.common.phetcommon.model.ModelElement;
import edu.colorado.phet.common.phetcommon.model.Particle;
import edu.colorado.phet.reactionsandrates.model.CompositeMolecule;
import edu.colorado.phet.reactionsandrates.model.PotentialEnergySource;
import java.awt.geom.Point2D;

public class Spring
extends Particle
implements ModelElement,
PotentialEnergySource {
    double k;
    double omega;
    double phi;
    double A;
    double restingLength;
    private Point2D fixedEnd;
    private double angle;
    private Point2D freeEnd;
    Body attachedBody;
    double t;
    private double pe;

    public MutableVector2D getAcceleration() {
        double d = -(this.omega * this.omega) * this.A * Math.sin(this.omega * this.t + this.phi);
        MutableVector2D mutableVector2D = new MutableVector2D(d, 0.0);
        mutableVector2D.rotate(this.angle);
        return mutableVector2D;
    }

    public void stepInTime(double d) {
        MutableVector2D mutableVector2D = this.getVelocity();
        this.t += d;
        if (this.attachedBody != null) {
            if (this.attachedBody instanceof CompositeMolecule) {
                // empty if block
            }
            double d2 = this.A * Math.sin(this.omega * this.t + this.phi);
            double d3 = this.restingLength - d2;
            this.pe = 0.5 * this.k * d2 * d2;
            this.freeEnd.setLocation(this.fixedEnd.getX() + d3 * Math.cos(this.angle), this.fixedEnd.getY() + d3 * Math.sin(this.angle));
            MutableVector2D mutableVector2D2 = this.getFreeEndVelocity();
            this.attachedBody.setVelocity(mutableVector2D2);
        }
        this.notifyObservers();
    }

    private MutableVector2D getFreeEndVelocity() {
        MutableVector2D mutableVector2D = new MutableVector2D(-this.omega * this.A * Math.cos(this.omega * this.t + this.phi), 0.0);
        mutableVector2D.rotate(this.angle);
        return mutableVector2D;
    }

    public double getPotentialEnergy() {
        double d = this.restingLength - this.fixedEnd.distance(this.freeEnd);
        this.pe = this.k * d * d / 2.0;
        return this.pe;
    }

    public Body getAttachedBody() {
        return this.attachedBody;
    }

    public double getPE() {
        return this.getPotentialEnergy();
    }
}

