/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.reactionsandrates.model.collision;

import edu.colorado.phet.common.mechanics.Body;
import edu.colorado.phet.common.phetcommon.model.ModelElement;
import edu.colorado.phet.reactionsandrates.model.CompositeBody;
import edu.colorado.phet.reactionsandrates.model.PotentialEnergySource;
import edu.colorado.phet.reactionsandrates.model.collision.Spring;
import java.awt.geom.Point2D;

public class ReactionSpring
extends Body
implements ModelElement,
PotentialEnergySource {
    private Spring[] componentSprings;
    private CompositeBody cb;

    public void stepInTime(double d) {
        super.stepInTime(d);
        double d2 = this.getPotentialEnergy();
        double d3 = 0.0;
        double d4 = 0.0;
        for (int i = 0; i < this.componentSprings.length; ++i) {
            d3 += this.componentSprings[i].getAttachedBody().getKineticEnergy();
            this.componentSprings[i].stepInTime(d);
            d4 += this.componentSprings[i].getAttachedBody().getKineticEnergy();
        }
        double d5 = this.getPotentialEnergy();
        double d6 = d5 + d4 - (d2 + d3);
        this.notifyObservers();
    }

    public Point2D getCM() {
        return this.cb.getCM();
    }

    public double getMomentOfInertia() {
        return this.cb.getMomentOfInertia();
    }

    public double getPotentialEnergy() {
        return this.componentSprings[0].getPotentialEnergy() + this.componentSprings[1].getPotentialEnergy();
    }

    public double getPE() {
        return this.getPotentialEnergy();
    }
}

