/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.reactionsandrates.model.collision;

import edu.colorado.phet.common.mechanics.Body;
import edu.colorado.phet.common.mechanics.Vector3D;
import edu.colorado.phet.common.phetcommon.math.vector.MutableVector2D;
import edu.colorado.phet.reactionsandrates.model.AbstractMolecule;
import edu.colorado.phet.reactionsandrates.model.CompositeMolecule;
import edu.colorado.phet.reactionsandrates.model.MRBox;
import edu.colorado.phet.reactionsandrates.model.MRModel;
import edu.colorado.phet.reactionsandrates.model.SimpleMolecule;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;

public class MoleculeBoxCollisionAgent {
    private MutableVector2D loa = new MutableVector2D();
    private Point2D.Double collisionPt = new Point2D.Double();
    private MutableVector2D n = new MutableVector2D();
    private MRModel model;

    public MoleculeBoxCollisionAgent(MRModel mRModel) {
        this.model = mRModel;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean detectAndDoCollision(Body body, Body body2) {
        AbstractMolecule abstractMolecule;
        MRBox mRBox = null;
        if (body instanceof MRBox) {
            mRBox = (MRBox)body;
            if (!(body2 instanceof AbstractMolecule)) throw new RuntimeException("bad args");
            abstractMolecule = (AbstractMolecule)body2;
        } else {
            if (!(body2 instanceof MRBox)) throw new RuntimeException("bad args");
            mRBox = (MRBox)body2;
            if (!(body instanceof AbstractMolecule)) throw new RuntimeException("bad args");
            abstractMolecule = (AbstractMolecule)body;
        }
        if (!this.detectCollision(abstractMolecule, mRBox)) return false;
        this.doCollision(abstractMolecule, this.loa, this.collisionPt);
        return true;
    }

    private boolean detectCollision(AbstractMolecule abstractMolecule, MRBox mRBox) {
        boolean bl = false;
        MutableVector2D mutableVector2D = abstractMolecule.getVelocity();
        if (abstractMolecule instanceof CompositeMolecule) {
            CompositeMolecule compositeMolecule = (CompositeMolecule)abstractMolecule;
            SimpleMolecule[] simpleMoleculeArray = compositeMolecule.getComponentMolecules();
            for (int i = 0; i < simpleMoleculeArray.length && !bl; ++i) {
                SimpleMolecule simpleMolecule = simpleMoleculeArray[i];
                bl = this.detectCollision(simpleMolecule, mRBox);
            }
        } else if (abstractMolecule instanceof SimpleMolecule) {
            SimpleMolecule simpleMolecule = (SimpleMolecule)abstractMolecule;
            Line2D.Double double_ = new Line2D.Double();
            this.loa.setComponents(0.0, 0.0);
            ((Line2D)double_).setLine(mRBox.getMinX(), mRBox.getMinY(), mRBox.getMinX(), mRBox.getMaxY());
            if (mutableVector2D.getX() < 0.0 && simpleMolecule.getPosition().getX() - simpleMolecule.getRadius() < ((Line2D)double_).getX1()) {
                this.loa.setComponents(this.loa.getX() - 1.0, this.loa.getY() + 0.0);
                this.collisionPt.setLocation(mRBox.getMinX(), simpleMolecule.getCM().getY());
                bl = true;
            }
            ((Line2D)double_).setLine(mRBox.getMaxX(), mRBox.getMinY(), mRBox.getMaxX(), mRBox.getMaxY());
            if (mutableVector2D.getX() > 0.0 && simpleMolecule.getPosition().getX() + simpleMolecule.getRadius() > ((Line2D)double_).getX1()) {
                this.loa.setComponents(this.loa.getX() + 1.0, this.loa.getY() + 0.0);
                this.collisionPt.setLocation(mRBox.getMaxX(), simpleMolecule.getCM().getY());
                bl = true;
            }
            ((Line2D)double_).setLine(mRBox.getMinX(), mRBox.getMaxY(), mRBox.getMaxX(), mRBox.getMaxY());
            if (mutableVector2D.getY() > 0.0 && simpleMolecule.getPosition().getY() + simpleMolecule.getRadius() > ((Line2D)double_).getY1()) {
                this.loa.setComponents(this.loa.getX() + 0.0, this.loa.getY() + 1.0);
                this.collisionPt.setLocation(simpleMolecule.getCM().getX(), mRBox.getMaxY());
                bl = true;
            }
            ((Line2D)double_).setLine(mRBox.getMinX(), mRBox.getMinY(), mRBox.getMaxX(), mRBox.getMinY());
            if (mutableVector2D.getY() < 0.0 && simpleMolecule.getPosition().getY() - simpleMolecule.getRadius() < ((Line2D)double_).getY1()) {
                this.loa.setComponents(this.loa.getX() + 0.0, this.loa.getY() - 1.0);
                this.collisionPt.setLocation(simpleMolecule.getCM().getX(), mRBox.getMinY());
                bl = true;
            }
            if (bl && this.loa.getX() != 0.0 && this.loa.getY() != 0.0) {
                this.loa.scale(Math.sin(0.7853981633974483));
                this.collisionPt.setLocation(simpleMolecule.getCM().getX() + this.loa.getX(), simpleMolecule.getCM().getY() + this.loa.getY());
            }
        }
        return bl;
    }

    public void doCollision(AbstractMolecule abstractMolecule, MutableVector2D mutableVector2D, Point2D.Double double_) {
        double d = abstractMolecule.getKineticEnergy();
        MutableVector2D mutableVector2D2 = new MutableVector2D(double_.getX() - abstractMolecule.getCM().getX(), double_.getY() - abstractMolecule.getCM().getY());
        this.n.setComponents(mutableVector2D.getX(), mutableVector2D.getY());
        this.n.normalize();
        Vector3D vector3D = new Vector3D(0.0, 0.0, (float)abstractMolecule.getOmega());
        Vector3D vector3D2 = vector3D.crossProduct(new Vector3D(mutableVector2D2)).add(new Vector3D(abstractMolecule.getVelocity()));
        double d2 = vector3D2.dot(new Vector3D(this.n));
        float f = 1.0f;
        double d3 = -d2 * (double)(1.0f + f);
        Vector3D vector3D3 = new Vector3D(this.n);
        Vector3D vector3D4 = new Vector3D(mutableVector2D2);
        Vector3D vector3D5 = vector3D4.crossProduct(vector3D3).multiply(1.0 / abstractMolecule.getMomentOfInertia());
        Vector3D vector3D6 = vector3D5.crossProduct(vector3D5);
        double d4 = vector3D3.dot(vector3D6);
        double d5 = 1.0 / abstractMolecule.getMass() + d4;
        d5 = 1.0 / abstractMolecule.getMass() + vector3D3.dot(vector3D4.crossProduct(vector3D3).multiply(1.0 / abstractMolecule.getMomentOfInertia()).crossProduct(vector3D4));
        double d6 = d3 / d5;
        abstractMolecule.getVelocity().add(new MutableVector2D(this.n).scale(d6 / abstractMolecule.getMass()));
        abstractMolecule.setOmega(abstractMolecule.getOmega() + (mutableVector2D2.getX() * this.n.getY() - mutableVector2D2.getY() * this.n.getX()) * d6 / abstractMolecule.getMomentOfInertia());
    }
}

