/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.reactionsandrates.model;

import edu.colorado.phet.common.phetcommon.model.ModelElement;
import edu.colorado.phet.common.phetcommon.util.EventChannel;
import edu.colorado.phet.reactionsandrates.model.MRModel;
import edu.colorado.phet.reactionsandrates.model.PublishingModel;
import edu.colorado.phet.reactionsandrates.model.Selectable;
import edu.colorado.phet.reactionsandrates.model.SimpleMolecule;
import java.util.Collection;
import java.util.EventListener;
import java.util.List;

public class SelectedMoleculeTracker
extends PublishingModel.ModelListenerAdapter
implements ModelElement,
SimpleMolecule.ChangeListener {
    private MRModel model;
    private SimpleMolecule moleculeTracked;
    private SimpleMolecule closestMolecule;
    private EventChannel listenerEventChannel = new EventChannel(Listener.class);
    private Listener listenerProxy = (Listener)this.listenerEventChannel.getListenerProxy();

    public SelectedMoleculeTracker(MRModel mRModel) {
        this.model = mRModel;
        mRModel.addListener(this);
    }

    private void setMoleculeTracked(SimpleMolecule simpleMolecule) {
        SimpleMolecule simpleMolecule2 = this.moleculeTracked;
        if (simpleMolecule2 != simpleMolecule) {
            if (simpleMolecule2 != null && simpleMolecule2.getSelectionStatus() != Selectable.NOT_SELECTED) {
                simpleMolecule2.setSelectionStatus(Selectable.NOT_SELECTED);
            }
            this.moleculeTracked = simpleMolecule;
            this.determineNearestToSelected();
            this.listenerProxy.moleculeBeingTrackedChanged(simpleMolecule, simpleMolecule2);
        }
    }

    private void setClosestMolecule(SimpleMolecule simpleMolecule) {
        SimpleMolecule simpleMolecule2 = this.closestMolecule;
        if (simpleMolecule2 != simpleMolecule) {
            if (simpleMolecule2 != null && simpleMolecule2.getSelectionStatus() != Selectable.NOT_SELECTED) {
                simpleMolecule2.setSelectionStatus(Selectable.NOT_SELECTED);
            }
            this.closestMolecule = simpleMolecule;
            this.listenerProxy.closestMoleculeChanged(this.closestMolecule, simpleMolecule2);
            this.listenerProxy.moleculeBeingTrackedChanged(this.moleculeTracked, this.moleculeTracked);
        }
    }

    public SimpleMolecule getMoleculeTracked() {
        return this.moleculeTracked;
    }

    public SimpleMolecule getClosestMolecule() {
        return this.closestMolecule;
    }

    public void stepInTime(double d) {
        this.determineNearestToSelected();
    }

    private void determineNearestToSelected() {
        List list = this.model.selectFor(SimpleMolecule.class);
        if (this.moleculeTracked != null) {
            Collection collection = this.moleculeTracked.getFullMolecule().getComponentMoleculesAsList();
            SimpleMolecule simpleMolecule = null;
            double d = Double.POSITIVE_INFINITY;
            for (int i = 0; i < list.size(); ++i) {
                double d2;
                SimpleMolecule simpleMolecule2 = (SimpleMolecule)list.get(i);
                if (simpleMolecule2 == this.moleculeTracked || collection.contains(simpleMolecule2) || !((d2 = this.moleculeTracked.getPosition().distanceSq(simpleMolecule2.getPosition())) < d)) continue;
                d = d2;
                simpleMolecule = simpleMolecule2;
            }
            this.setClosestMolecule(simpleMolecule);
        } else {
            this.setClosestMolecule(null);
        }
    }

    public void modelElementAdded(ModelElement modelElement) {
        if (modelElement instanceof SimpleMolecule) {
            ((SimpleMolecule)modelElement).addListener(this);
        }
    }

    public void modelElementRemoved(ModelElement modelElement) {
        if (modelElement instanceof SimpleMolecule) {
            ((SimpleMolecule)modelElement).removeListener(this);
        }
    }

    public void selectionStatusChanged(SimpleMolecule simpleMolecule) {
        if (simpleMolecule.getSelectionStatus() == Selectable.SELECTED) {
            this.setMoleculeTracked(simpleMolecule);
        }
        if (this.getMoleculeTracked() == simpleMolecule && simpleMolecule.getSelectionStatus() != Selectable.SELECTED) {
            this.setMoleculeTracked(null);
            this.setClosestMolecule(null);
        }
    }

    public void addListener(Listener listener) {
        this.listenerEventChannel.addListener(listener);
    }

    public void removeListener(Listener listener) {
        this.listenerEventChannel.removeListener(listener);
    }

    public static interface Listener
    extends EventListener {
        public void moleculeBeingTrackedChanged(SimpleMolecule var1, SimpleMolecule var2);

        public void closestMoleculeChanged(SimpleMolecule var1, SimpleMolecule var2);
    }
}

