/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.reactionsandrates.model;

import edu.colorado.phet.common.phetcommon.model.BaseModel;
import edu.colorado.phet.common.phetcommon.model.ModelElement;
import edu.colorado.phet.common.phetcommon.model.clock.ClockAdapter;
import edu.colorado.phet.common.phetcommon.model.clock.ClockEvent;
import edu.colorado.phet.common.phetcommon.model.clock.IClock;
import edu.colorado.phet.common.phetcommon.util.EventChannel;
import java.util.ArrayList;
import java.util.EventListener;

public class PublishingModel
extends BaseModel {
    private EventChannel eventChannel = new EventChannel(ModelListener.class);
    private ModelListener modelListenerProxy = (ModelListener)this.eventChannel.getListenerProxy();
    private ArrayList modelElements = new ArrayList();

    public void addListener(ModelListener modelListener) {
        this.eventChannel.addListener(modelListener);
    }

    public PublishingModel(IClock iClock) {
        iClock.addClockListener(new ModelStepper(this));
    }

    public void addModelElement(ModelElement modelElement) {
        super.addModelElement(modelElement);
        this.modelElements.add(modelElement);
        this.modelListenerProxy.modelElementAdded(modelElement);
    }

    public void removeModelElement(ModelElement modelElement) {
        super.removeModelElement(modelElement);
        this.modelElements.remove(modelElement);
        this.modelListenerProxy.modelElementRemoved(modelElement);
    }

    public ArrayList getModelElements() {
        return this.modelElements;
    }

    public static interface ModelListener
    extends EventListener {
        public void modelElementAdded(ModelElement var1);

        public void modelElementRemoved(ModelElement var1);

        public void endOfTimeStep(PublishingModel var1, ClockEvent var2);
    }

    public static class ModelListenerAdapter
    implements ModelListener {
        public void modelElementAdded(ModelElement modelElement) {
        }

        public void modelElementRemoved(ModelElement modelElement) {
        }

        public void endOfTimeStep(PublishingModel publishingModel, ClockEvent clockEvent) {
        }
    }

    private static class ModelStepper
    extends ClockAdapter {
        private PublishingModel model;

        public ModelStepper(PublishingModel publishingModel) {
            this.model = publishingModel;
        }

        public void clockTicked(ClockEvent clockEvent) {
            this.model.stepInTime(clockEvent.getSimulationTimeChange());
            this.model.modelListenerProxy.endOfTimeStep(this.model, clockEvent);
        }
    }
}

