/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.reactionsandrates.model;

import edu.colorado.phet.common.phetcommon.model.ModelElement;
import edu.colorado.phet.common.phetcommon.util.SimpleObservable;
import edu.colorado.phet.reactionsandrates.model.MRModel;
import edu.colorado.phet.reactionsandrates.model.PotentialEnergySource;
import edu.colorado.phet.reactionsandrates.model.SimpleMolecule;
import edu.colorado.phet.reactionsandrates.model.collision.ReactionSpring;

public class ProvisionalBond
extends SimpleObservable
implements ModelElement,
PotentialEnergySource {
    SimpleMolecule[] molecules;
    private double maxBondLength;
    private MRModel model;
    private ReactionSpring spring;

    public void stepInTime(double d) {
        double d2 = this.model.getReaction().getDistanceToCollision(this.molecules[0].getFullMolecule(), this.molecules[1].getFullMolecule());
        if (d2 > this.maxBondLength) {
            this.model.removeModelElement(this);
            this.model.removeModelElement(this.spring);
            if (this.spring != null && this.spring.getPotentialEnergy() != 0.0) {
                double d3 = this.spring.getPotentialEnergy();
                double d4 = this.getMolecules()[0].getFullMolecule().getVelocity().magnitude();
                double d5 = Math.sqrt(d3 / this.getMolecules()[0].getFullMass() + d4 * d4);
                this.getMolecules()[0].getFullMolecule().setVelocity(this.getMolecules()[0].getFullMolecule().getVelocity().normalize().scale(d5));
                double d6 = this.getMolecules()[1].getFullMolecule().getVelocity().magnitude();
                double d7 = Math.sqrt(d3 / this.getMolecules()[1].getFullMass() + d6 * d6);
                this.getMolecules()[1].getFullMolecule().setVelocity(this.getMolecules()[1].getFullMolecule().getVelocity().normalize().scale(d7));
            }
        }
        this.notifyObservers();
    }

    public SimpleMolecule[] getMolecules() {
        return this.molecules;
    }

    public double getMaxBondLength() {
        return this.maxBondLength;
    }

    public double getPotentialEnergy() {
        double d = 0.0;
        if (this.spring != null) {
            d = this.spring.getPotentialEnergy();
        }
        return d;
    }

    public double getPE() {
        return this.getPotentialEnergy();
    }
}

