/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.reactionsandrates.model;

import edu.colorado.phet.common.phetcommon.math.vector.MutableVector2D;
import edu.colorado.phet.reactionsandrates.model.AbstractMolecule;
import edu.colorado.phet.reactionsandrates.model.MoleculeA;
import edu.colorado.phet.reactionsandrates.model.MoleculeAB;
import edu.colorado.phet.reactionsandrates.model.MoleculeB;
import edu.colorado.phet.reactionsandrates.model.MoleculeBC;
import edu.colorado.phet.reactionsandrates.model.MoleculeC;
import edu.colorado.phet.reactionsandrates.model.MoleculeParamGenerator;
import edu.colorado.phet.reactionsandrates.model.SimpleMolecule;
import java.awt.geom.Point2D;

public class MoleculeFactory {
    public static AbstractMolecule createMolecule(Class clazz, MoleculeParamGenerator moleculeParamGenerator) {
        AbstractMolecule abstractMolecule = null;
        MoleculeParamGenerator.Params params = moleculeParamGenerator.generate();
        Point2D point2D = params.getPosition();
        MutableVector2D mutableVector2D = params.getVelocity();
        double d = params.getAngularVelocity();
        if (clazz == MoleculeAB.class) {
            MoleculeA moleculeA = new MoleculeA();
            moleculeA.setVelocity(mutableVector2D);
            MoleculeB moleculeB = new MoleculeB();
            moleculeB.setVelocity(mutableVector2D);
            abstractMolecule = new MoleculeAB(new SimpleMolecule[]{moleculeA, moleculeB});
            abstractMolecule.setOmega(d);
            double d2 = MoleculeFactory.getComponentMoleculesOffset(moleculeA, moleculeB);
            moleculeA.setPosition(point2D.getX() - d2 / 2.0, point2D.getY());
            moleculeB.setPosition(point2D.getX() + d2 / 2.0, point2D.getY());
        } else if (clazz == MoleculeBC.class) {
            MoleculeC moleculeC = new MoleculeC();
            moleculeC.setVelocity(mutableVector2D);
            MoleculeB moleculeB = new MoleculeB();
            moleculeB.setVelocity(mutableVector2D);
            abstractMolecule = new MoleculeBC(new SimpleMolecule[]{moleculeC, moleculeB});
            abstractMolecule.setOmega(d);
            double d3 = MoleculeFactory.getComponentMoleculesOffset(moleculeC, moleculeB);
            moleculeC.setPosition(point2D.getX() - d3 / 2.0, point2D.getY());
            moleculeB.setPosition(point2D.getX() + d3 / 2.0, point2D.getY());
        } else {
            try {
                abstractMolecule = (AbstractMolecule)clazz.newInstance();
            }
            catch (InstantiationException instantiationException) {
                instantiationException.printStackTrace();
            }
            catch (IllegalAccessException illegalAccessException) {
                illegalAccessException.printStackTrace();
            }
        }
        abstractMolecule.setPosition(point2D);
        abstractMolecule.setVelocity(mutableVector2D);
        return abstractMolecule;
    }

    public static double getComponentMoleculesOffset(SimpleMolecule simpleMolecule, SimpleMolecule simpleMolecule2) {
        return Math.max(simpleMolecule.getRadius(), simpleMolecule2.getRadius());
    }
}

