/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.reactionsandrates.model;

import edu.colorado.phet.common.phetcommon.math.MathUtil;
import edu.colorado.phet.common.phetcommon.math.vector.MutableVector2D;
import edu.colorado.phet.reactionsandrates.model.CollisionParams;
import edu.colorado.phet.reactionsandrates.model.CompositeMolecule;
import edu.colorado.phet.reactionsandrates.model.MoleculeB;
import edu.colorado.phet.reactionsandrates.model.SimpleMolecule;

public class MRModelUtil {
    public static double getCollisionEnergy(SimpleMolecule simpleMolecule, CompositeMolecule compositeMolecule) {
        CollisionParams collisionParams = new CollisionParams(simpleMolecule, compositeMolecule);
        MutableVector2D mutableVector2D = new MutableVector2D(collisionParams.getbMolecule().getPosition(), collisionParams.getFreeMolecule().getPosition());
        if (collisionParams.getFreeMolecule() instanceof MoleculeB) {
            new CollisionParams(simpleMolecule, compositeMolecule);
        }
        mutableVector2D.normalize();
        double d = collisionParams.getFreeMolecule().getVelocity().dot(mutableVector2D);
        double d2 = collisionParams.getCompositeMolecule().getVelocity().dot(mutableVector2D);
        double d3 = -MathUtil.getSign(d);
        double d4 = MathUtil.getSign(d2);
        double d5 = (d3 * simpleMolecule.getMass() * d * d + d4 * compositeMolecule.getMass() * d2 * d2) / 2.0;
        d5 = Math.max(d5, 0.0);
        return d5;
    }
}

