/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.reactionsandrates.model;

import edu.colorado.phet.common.mechanics.DefaultBody;
import edu.colorado.phet.common.phetcommon.math.vector.MutableVector2D;
import edu.colorado.phet.common.phetcommon.model.ModelElement;
import edu.colorado.phet.common.phetcommon.util.EventChannel;
import edu.colorado.phet.reactionsandrates.model.PotentialEnergySource;
import edu.colorado.phet.reactionsandrates.model.SimpleMolecule;
import java.awt.geom.Point2D;
import java.util.EventListener;

public class Launcher
extends DefaultBody
implements ModelElement,
PotentialEnergySource {
    public static MovementType ONE_DIMENSIONAL = new MovementType();
    public static MovementType TWO_DIMENSIONAL = new MovementType();
    private Point2D restingTipLocation;
    private double springK = 0.2;
    private SimpleMolecule bodyToLaunch;
    private MovementType movementType = TWO_DIMENSIONAL;
    private boolean enabled;
    private double extension;
    private EventChannel changeEventChannel = new EventChannel(ChangeListener.class);
    private ChangeListener changeListenerProxy = (ChangeListener)this.changeEventChannel.getListenerProxy();

    public Launcher(Point2D point2D) {
        this.restingTipLocation = point2D;
    }

    public void setBodyToLaunch(SimpleMolecule simpleMolecule) {
        this.bodyToLaunch = simpleMolecule;
        simpleMolecule.setVelocity(0.0, 0.0);
        this.setEnabled(true);
    }

    public void release() {
        if (this.bodyToLaunch != null && this.extension > 2.0) {
            double d = Math.sqrt(2.0 * this.getPE() / this.bodyToLaunch.getMass());
            MutableVector2D mutableVector2D = new MutableVector2D(0.0, -d);
            mutableVector2D.rotate(this.getTheta());
            this.bodyToLaunch.setVelocity(mutableVector2D);
            this.bodyToLaunch = null;
            this.enabled = false;
        }
        this.setExtension(0.0);
    }

    private void setEnabled(boolean bl) {
        this.enabled = bl;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public double getPE() {
        double d = this.getExtension();
        double d2 = this.springK * d * d / 2.0;
        return d2;
    }

    public double getExtension() {
        return this.extension;
    }

    public void setTheta(double d) {
        if (d >= -0.7853981633974483 && d <= 0.7853981633974483) {
            super.setTheta(d);
            this.notifyObservers();
        }
    }

    public void stepInTime(double d) {
    }

    public Point2D getRestingTipLocation() {
        return this.restingTipLocation;
    }

    public void setExtension(double d) {
        if (d >= 0.0 && d <= 70.0) {
            this.extension = d;
        }
    }

    public void setMovementType(MovementType movementType) {
        this.movementType = movementType;
        this.changeListenerProxy.stateChanged(this);
    }

    public MovementType getMovementType() {
        return this.movementType;
    }

    public void addChangeListener(ChangeListener changeListener) {
        this.changeEventChannel.addListener(changeListener);
    }

    public static interface ChangeListener
    extends EventListener {
        public void stateChanged(Launcher var1);
    }

    public static class MovementType {
        private MovementType() {
        }
    }
}

