/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.reactionsandrates.model;

import edu.colorado.phet.common.phetcommon.math.vector.MutableVector2D;
import edu.colorado.phet.reactionsandrates.model.AbstractMolecule;
import edu.colorado.phet.reactionsandrates.model.MRModel;
import edu.colorado.phet.reactionsandrates.model.MoleculeA;
import edu.colorado.phet.reactionsandrates.model.MoleculeAB;
import edu.colorado.phet.reactionsandrates.model.MoleculeB;
import edu.colorado.phet.reactionsandrates.model.MoleculeBC;
import edu.colorado.phet.reactionsandrates.model.MoleculeC;
import edu.colorado.phet.reactionsandrates.model.MoleculeParamGenerator;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.Random;

public class ConstantTemperatureMoleculeParamGenerator
implements MoleculeParamGenerator {
    private static Random random = new Random();
    private static AbstractMolecule prototypeA = new MoleculeA();
    private static AbstractMolecule prototypeB = new MoleculeB();
    private static AbstractMolecule prototypeC = new MoleculeC();
    private Rectangle2D bounds;
    private MRModel model;
    private double minTheta;
    private double maxTheta;
    private double maxAlpha;
    private double mass = 0.0;

    public ConstantTemperatureMoleculeParamGenerator(Rectangle2D rectangle2D, MRModel mRModel, double d, double d2, double d3, Class clazz) {
        this.bounds = rectangle2D;
        this.model = mRModel;
        this.minTheta = d2;
        this.maxTheta = d3;
        this.maxAlpha = d;
        if (clazz == MoleculeA.class) {
            this.mass = prototypeA.getMass();
        }
        if (clazz == MoleculeBC.class) {
            this.mass = prototypeB.getMass() + prototypeC.getMass();
        }
        if (clazz == MoleculeAB.class) {
            this.mass = prototypeA.getMass() + prototypeB.getMass();
        }
        if (clazz == MoleculeC.class) {
            this.mass = prototypeC.getMass();
        }
    }

    public MoleculeParamGenerator.Params generate() {
        double d = this.bounds.getMinX() + random.nextDouble() * this.bounds.getWidth();
        double d2 = this.bounds.getMinY() + random.nextDouble() * this.bounds.getHeight();
        Point2D.Double double_ = new Point2D.Double(d, d2);
        double d3 = Math.sqrt(2.0 * this.model.getTemperature() / this.mass);
        double d4 = (this.maxTheta - this.minTheta) * random.nextDouble() + this.minTheta;
        MutableVector2D mutableVector2D = new MutableVector2D(d3, 0.0).rotate(d4);
        double d5 = 0.0;
        return new MoleculeParamGenerator.Params(double_, mutableVector2D, d5);
    }
}

