/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.reactionsandrates.model;

import edu.colorado.phet.common.collision.CollidableAdapter;
import edu.colorado.phet.common.mechanics.Body;
import edu.colorado.phet.common.phetcommon.math.vector.MutableVector2D;
import edu.colorado.phet.common.phetcommon.util.EventChannel;
import edu.colorado.phet.reactionsandrates.model.CompositeMolecule;
import edu.colorado.phet.reactionsandrates.model.KineticEnergySource;
import edu.colorado.phet.reactionsandrates.model.SimpleMolecule;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.Arrays;
import java.util.Collection;
import java.util.EventListener;

public abstract class AbstractMolecule
extends Body
implements KineticEnergySource,
Cloneable {
    public static EventChannel classEventChannel = new EventChannel(ClassListener.class);
    private CollidableAdapter collidableAdapter;
    private CompositeMolecule parentComposite;
    private ClassListener classListenerProxy = (ClassListener)classEventChannel.getListenerProxy();
    private EventChannel listenerChannel = new EventChannel(ChangeListener.class);
    private ChangeListener changeListenerProxy = (ChangeListener)this.listenerChannel.getListenerProxy();

    public static void addClassListener(ClassListener classListener) {
        classEventChannel.addListener(classListener);
    }

    public Object clone() {
        AbstractMolecule abstractMolecule = (AbstractMolecule)super.clone();
        abstractMolecule.collidableAdapter = new CollidableAdapter(this);
        abstractMolecule.parentComposite = this.parentComposite == null ? null : (CompositeMolecule)this.parentComposite.clone();
        return abstractMolecule;
    }

    protected AbstractMolecule() {
        this(new Point2D.Double(), new MutableVector2D(), new MutableVector2D(), 0.0, 0.0);
        this.collidableAdapter = new CollidableAdapter(this);
    }

    protected AbstractMolecule(Point2D point2D, MutableVector2D mutableVector2D, MutableVector2D mutableVector2D2, double d, double d2) {
        super(point2D, mutableVector2D, mutableVector2D2, d, d2);
        this.collidableAdapter = new CollidableAdapter(this);
    }

    public void setPosition(double d, double d2) {
        if (this.collidableAdapter != null) {
            this.collidableAdapter.updatePosition();
        }
        super.setPosition(d, d2);
    }

    public void setPosition(Point2D point2D) {
        if (this.collidableAdapter != null) {
            this.collidableAdapter.updatePosition();
        }
        super.setPosition(point2D);
    }

    public MutableVector2D getVelocity() {
        return super.getVelocity();
    }

    public void setVelocity(MutableVector2D mutableVector2D) {
        if (this.collidableAdapter != null) {
            this.collidableAdapter.updateVelocity();
        }
        super.setVelocity(mutableVector2D);
    }

    public void setVelocity(double d, double d2) {
        if (this.collidableAdapter != null) {
            this.collidableAdapter.updateVelocity();
        }
        super.setVelocity(d, d2);
    }

    public Point2D getPositionPrev() {
        return this.collidableAdapter.getPositionPrev();
    }

    public boolean isPartOfComposite() {
        return this.parentComposite != null;
    }

    public boolean isComposite() {
        return !this.isPartOfComposite() && this.getComponentMolecules().length > 1;
    }

    public boolean isWholeMolecule() {
        return !this.isPartOfComposite();
    }

    public CompositeMolecule getParentComposite() {
        return this.parentComposite;
    }

    public void setParentComposite(CompositeMolecule compositeMolecule) {
        this.parentComposite = compositeMolecule;
        this.classListenerProxy.statusChanged(this);
        this.changeListenerProxy.compositeStateChanged(this);
    }

    public AbstractMolecule getFullMolecule() {
        if (this.isPartOfComposite()) {
            return this.getParentComposite().getFullMolecule();
        }
        return this;
    }

    public double getKineticEnergy() {
        if (!this.isPartOfComposite()) {
            return super.getKineticEnergy();
        }
        return 0.0;
    }

    public void stepInTime(double d) {
        if (!this.isPartOfComposite()) {
            super.stepInTime(d);
        }
    }

    public String toString() {
        return this.getClass().getName() + this.hashCode();
    }

    public abstract SimpleMolecule[] getComponentMolecules();

    public final Collection getComponentMoleculesAsList() {
        return Arrays.asList(this.getComponentMolecules());
    }

    public abstract Rectangle2D getBoundingBox();

    public static interface ChangeListener
    extends EventListener {
        public void compositeStateChanged(AbstractMolecule var1);
    }

    public static interface ClassListener
    extends EventListener {
        public void statusChanged(AbstractMolecule var1);
    }
}

