/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.reactionsandrates.controller;

import edu.colorado.phet.reactionsandrates.model.EnergyProfile;
import edu.colorado.phet.reactionsandrates.model.reactions.Profiles;
import edu.colorado.phet.reactionsandrates.modules.MRModule;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;

public class SelectReactionAction
extends AbstractAction {
    public static String R1_ACTION = "R1";
    public static String R2_ACTION = "R2";
    public static String R3_ACTION = "R3";
    public static String DESIGN_YOUR_OWN_ACTION = "design your own";
    public static String DEFAULT_ACTION = "default";
    private static Reaction R1 = new Reaction(Profiles.R1);
    private static Reaction R2 = new Reaction(Profiles.R2);
    private static Reaction R3 = new Reaction(Profiles.R3);
    private static Reaction DEFAULT = new Reaction(Profiles.DEFAULT);
    private static Reaction DYO = new Reaction(Profiles.DYO);
    private Reaction currentReaction;
    private MRModule module;

    public SelectReactionAction(MRModule mRModule) {
        this.module = mRModule;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        this.setReaction(actionEvent.getActionCommand());
    }

    private void setReaction(String string) {
        boolean bl = false;
        if (string.equals(R1_ACTION)) {
            this.currentReaction = R1;
        } else if (string.equals(R2_ACTION)) {
            this.currentReaction = R2;
        } else if (string.equals(R3_ACTION)) {
            this.currentReaction = R3;
        } else if (string.equals(DESIGN_YOUR_OWN_ACTION)) {
            this.currentReaction = DYO;
            bl = true;
        } else if (string.equals(DEFAULT_ACTION)) {
            this.currentReaction = DEFAULT;
        } else {
            throw new IllegalArgumentException();
        }
        if (this.currentReaction != null) {
            this.module.getMRModel().setEnergyProfile(this.currentReaction.getEnergyProfile());
            this.module.clearExperiment();
            this.module.getMRModel().setEnergyProfile(this.currentReaction.getEnergyProfile());
        }
        this.module.getEnergyView().setProfileManipulable(bl);
    }

    private static class Reaction {
        EnergyProfile energyProfile;

        public Reaction(EnergyProfile energyProfile) {
            this.energyProfile = energyProfile;
        }

        public EnergyProfile getEnergyProfile() {
            return this.energyProfile;
        }
    }
}

