/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.reactantsproductsandleftovers.view.sandwich;

import edu.colorado.phet.common.phetcommon.simsharing.messages.IUserComponent;
import edu.colorado.phet.common.phetcommon.simsharing.messages.UserComponent;
import edu.colorado.phet.common.phetcommon.simsharing.messages.UserComponentChain;
import edu.colorado.phet.common.phetcommon.view.util.PhetFont;
import edu.colorado.phet.common.piccolophet.PhetPNode;
import edu.colorado.phet.common.piccolophet.util.PNodeLayoutUtils;
import edu.colorado.phet.reactantsproductsandleftovers.RPALSimSharing;
import edu.colorado.phet.reactantsproductsandleftovers.RPALStrings;
import edu.colorado.phet.reactantsproductsandleftovers.controls.IntegerSpinnerNode;
import edu.colorado.phet.reactantsproductsandleftovers.model.ChemicalReaction;
import edu.colorado.phet.reactantsproductsandleftovers.model.Product;
import edu.colorado.phet.reactantsproductsandleftovers.model.Reactant;
import edu.colorado.phet.reactantsproductsandleftovers.model.Substance;
import edu.colorado.phet.reactantsproductsandleftovers.module.sandwichshop.SandwichShopModel;
import edu.colorado.phet.reactantsproductsandleftovers.view.PlusNode;
import edu.colorado.phet.reactantsproductsandleftovers.view.RightArrowNode;
import edu.colorado.phet.reactantsproductsandleftovers.view.SubstanceImageNode;
import edu.umd.cs.piccolo.PNode;
import edu.umd.cs.piccolo.nodes.PText;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class SandwichEquationNode
extends PhetPNode {
    private static final PhetFont COEFFICIENT_FONT = new PhetFont(24);
    private static final PhetFont NO_REACTION_FONT = new PhetFont(24);
    private final ChemicalReaction reaction;
    private final PNode arrowNode;
    private final ArrayList<PNode> lhsCoefficientNodes;
    private final ArrayList<PNode> lhsImageNodes;
    private final ArrayList<PNode> lhsPlusNodes;
    private final ArrayList<PNode> rhsCoefficientNodes;
    private final ArrayList<PNode> rhsImageNodes;
    private final ArrayList<PNode> rhsPlusNodes;
    private final ArrayList<Reactant.ReactantChangeListener> reactantChangeListeners;
    private final ChangeListener reactionChangeListener;
    private final PText noReactionNode;

    public SandwichEquationNode(SandwichShopModel sandwichShopModel) {
        PNode pNode;
        Object object;
        PNode pNode2;
        Object object2;
        this.reaction = sandwichShopModel.getReaction();
        PropertyChangeListener propertyChangeListener = new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                if (propertyChangeEvent.getPropertyName().equals("image")) {
                    SandwichEquationNode.this.updateLayout();
                }
            }
        };
        this.lhsCoefficientNodes = new ArrayList();
        this.lhsImageNodes = new ArrayList();
        this.lhsPlusNodes = new ArrayList();
        this.reactantChangeListeners = new ArrayList();
        Reactant[] reactantArray = this.reaction.getReactants();
        for (int i = 0; i < reactantArray.length; ++i) {
            final Reactant reactant = reactantArray[i];
            object2 = UserComponentChain.chain(RPALSimSharing.UserComponents.equationSpinner, new UserComponent(reactant.getPlainTextName()));
            pNode2 = new IntegerSpinnerNode((IUserComponent)object2, SandwichShopModel.getCoefficientRange());
            pNode2.scale(2.0);
            ((IntegerSpinnerNode)pNode2).setValue(reactant.getCoefficient());
            ((IntegerSpinnerNode)pNode2).addChangeListener(new ChangeListener((IntegerSpinnerNode)pNode2){
                final /* synthetic */ IntegerSpinnerNode val$spinnerNode;
                {
                    this.val$spinnerNode = integerSpinnerNode;
                }

                public void stateChanged(ChangeEvent changeEvent) {
                    reactant.setCoefficient(this.val$spinnerNode.getValue());
                }
            });
            this.addChild(pNode2);
            this.lhsCoefficientNodes.add(pNode2);
            object = new Reactant.ReactantChangeAdapter((IntegerSpinnerNode)pNode2, reactant){
                final /* synthetic */ IntegerSpinnerNode val$spinnerNode;
                final /* synthetic */ Reactant val$reactant;
                {
                    this.val$spinnerNode = integerSpinnerNode;
                    this.val$reactant = reactant;
                }

                public void coefficientChanged() {
                    this.val$spinnerNode.setValue(this.val$reactant.getCoefficient());
                }
            };
            reactant.addReactantChangeListener((Reactant.ReactantChangeListener)object);
            this.reactantChangeListeners.add((Reactant.ReactantChangeListener)object);
            pNode = new SubstanceImageNode(reactant);
            pNode.scale(1.0);
            this.addChild(pNode);
            this.lhsImageNodes.add(pNode);
            if (i >= reactantArray.length - 1) continue;
            PlusNode plusNode = new PlusNode();
            this.addChild(plusNode);
            this.lhsPlusNodes.add(plusNode);
        }
        this.arrowNode = new RightArrowNode();
        this.addChild(this.arrowNode);
        this.rhsCoefficientNodes = new ArrayList();
        this.rhsImageNodes = new ArrayList();
        this.rhsPlusNodes = new ArrayList();
        Product[] productArray = this.reaction.getProducts();
        for (int i = 0; i < productArray.length; ++i) {
            object2 = productArray[i];
            pNode2 = new PText(String.valueOf(((Substance)object2).getCoefficient()));
            ((PText)pNode2).setFont(COEFFICIENT_FONT);
            this.addChild(pNode2);
            this.rhsCoefficientNodes.add(pNode2);
            object = new SubstanceImageNode((Substance)object2);
            ((PNode)object).addPropertyChangeListener(propertyChangeListener);
            ((PNode)object).scale(1.0);
            this.addChild((PNode)object);
            this.rhsImageNodes.add((PNode)object);
            if (i >= productArray.length - 1) continue;
            pNode = new PlusNode();
            this.addChild(pNode);
            this.rhsPlusNodes.add(pNode);
        }
        this.noReactionNode = new PText(RPALStrings.LABEL_NO_SANDWICH);
        this.noReactionNode.setFont(NO_REACTION_FONT);
        this.addChild(this.noReactionNode);
        this.reactionChangeListener = new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                SandwichEquationNode.this.updateVisibility();
            }
        };
        this.reaction.addChangeListener(this.reactionChangeListener);
        this.updateVisibility();
        this.updateLayout();
    }

    public void cleanup() {
        this.reaction.removeChangeListener(this.reactionChangeListener);
        Reactant[] reactantArray = this.reaction.getReactants();
        for (int i = 0; i < reactantArray.length; ++i) {
            reactantArray[i].removeReactantChangeListener(this.reactantChangeListeners.get(i));
        }
    }

    private void updateVisibility() {
        boolean bl = this.reaction.isReaction();
        this.noReactionNode.setVisible(!bl);
        for (PNode pNode : this.rhsCoefficientNodes) {
            pNode.setVisible(bl);
        }
        for (PNode pNode : this.rhsImageNodes) {
            pNode.setVisible(bl);
        }
        for (PNode pNode : this.rhsPlusNodes) {
            pNode.setVisible(bl);
        }
        this.updateLayout();
    }

    private void updateLayout() {
        PNode pNode;
        PNode pNode2;
        PNode pNode3;
        int n;
        PNode pNode4 = null;
        double d = 0.0;
        double d2 = 0.0;
        double d3 = 0.0;
        for (n = 0; n < this.lhsCoefficientNodes.size(); ++n) {
            pNode3 = this.lhsCoefficientNodes.get(n);
            if (n == 0) {
                d2 = 0.0;
                d3 = 0.0;
                pNode3.setOffset(d2, d3);
                d = d3;
            } else {
                d2 = pNode4.getFullBoundsReference().getMaxX() + 20.0;
                pNode3.setOffset(d2, d);
            }
            pNode2 = this.lhsImageNodes.get(n);
            d2 = pNode3.getFullBoundsReference().getMaxX() + 6.0;
            d3 = pNode3.getFullBoundsReference().getCenterY() - pNode2.getFullBoundsReference().getHeight() / 2.0 - PNodeLayoutUtils.getOriginYOffset(pNode2);
            pNode2.setOffset(d2, d3);
            if (n < this.lhsCoefficientNodes.size() - 1) {
                pNode = this.lhsPlusNodes.get(n);
                d2 = pNode2.getFullBoundsReference().getMaxX() + 20.0;
                d3 = pNode2.getFullBoundsReference().getCenterY() - pNode.getFullBoundsReference().getHeight() / 2.0 - PNodeLayoutUtils.getOriginYOffset(pNode);
                pNode.setOffset(d2, d3);
                pNode4 = pNode;
                continue;
            }
            pNode4 = pNode2;
        }
        d2 = pNode4.getFullBoundsReference().getMaxX() + 20.0;
        d3 = pNode4.getFullBoundsReference().getCenterY() - this.arrowNode.getFullBoundsReference().getHeight() / 2.0 - PNodeLayoutUtils.getOriginYOffset(this.arrowNode);
        this.arrowNode.setOffset(d2, d3);
        pNode4 = this.arrowNode;
        for (n = 0; n < this.rhsCoefficientNodes.size(); ++n) {
            pNode3 = this.rhsCoefficientNodes.get(n);
            d2 = pNode4.getFullBoundsReference().getMaxX() + 20.0;
            d3 = pNode4.getFullBoundsReference().getCenterY() - pNode3.getFullBoundsReference().getHeight() / 2.0 - -PNodeLayoutUtils.getOriginYOffset(pNode3);
            pNode3.setOffset(d2, d3);
            if (n == 0) {
                d3 = pNode4.getFullBoundsReference().getCenterY() - this.noReactionNode.getFullBoundsReference().getHeight() / 2.0 - -PNodeLayoutUtils.getOriginYOffset(this.noReactionNode);
                this.noReactionNode.setOffset(d2, d3);
            }
            pNode2 = this.rhsImageNodes.get(n);
            d2 = pNode3.getFullBoundsReference().getMaxX() + 6.0 - PNodeLayoutUtils.getOriginXOffset(pNode2);
            d3 = pNode3.getFullBoundsReference().getCenterY() - pNode2.getFullBoundsReference().getHeight() / 2.0 - PNodeLayoutUtils.getOriginYOffset(pNode2);
            pNode2.setOffset(d2, d3);
            if (n < this.rhsCoefficientNodes.size() - 1) {
                pNode = this.rhsPlusNodes.get(n);
                d2 = pNode2.getFullBoundsReference().getMaxX() + 20.0;
                d3 = pNode2.getFullBoundsReference().getCenterY() - pNode.getFullBoundsReference().getHeight() / 2.0 - PNodeLayoutUtils.getOriginYOffset(pNode);
                pNode.setOffset(d2, d3);
                pNode4 = pNode;
                continue;
            }
            pNode4 = pNode2;
        }
    }
}

