/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.reactantsproductsandleftovers.view.realreaction;

import edu.colorado.phet.common.phetcommon.view.util.HTMLUtils;
import edu.colorado.phet.common.phetcommon.view.util.PhetFont;
import edu.colorado.phet.common.piccolophet.nodes.HTMLNode;
import edu.colorado.phet.reactantsproductsandleftovers.model.ChemicalReaction;
import edu.colorado.phet.reactantsproductsandleftovers.model.Product;
import edu.colorado.phet.reactantsproductsandleftovers.model.Reactant;
import edu.colorado.phet.reactantsproductsandleftovers.view.PlusNode;
import edu.colorado.phet.reactantsproductsandleftovers.view.RightArrowNode;
import edu.umd.cs.piccolo.PNode;
import edu.umd.cs.piccolo.nodes.PPath;
import edu.umd.cs.piccolo.nodes.PText;
import edu.umd.cs.piccolox.nodes.PComposite;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.Stroke;
import java.awt.geom.Rectangle2D;

public class RealReactionEquationNode
extends PComposite {
    private static final Font FONT = new PhetFont(36);
    private static final Color NAME_COLOR = Color.BLACK;
    private static final Color COEFFICIENT_COLOR = Color.BLACK;
    private static final Stroke COEFFICIENT_BORDER_STROKE = new BasicStroke(0.5f);
    private static final Color COEFFICIENT_BORDER_COLOR = Color.BLACK;
    private final ChemicalReaction reaction;

    public RealReactionEquationNode(ChemicalReaction chemicalReaction) {
        this.reaction = chemicalReaction;
        this.update();
    }

    public void cleanup() {
    }

    private void update() {
        PNode pNode;
        Product[] productArray;
        this.removeAllChildren();
        double d = new NameNode("T").getFullBounds().getHeight();
        Reactant[] reactantArray = this.reaction.getReactants();
        double d2 = 0.0;
        double d3 = 0.0;
        PNode pNode2 = null;
        for (int i = 0; i < reactantArray.length; ++i) {
            productArray = null;
            if (i > 0) {
                productArray = new PlusNode();
                this.addChild((PNode)productArray);
                d2 = pNode2.getFullBoundsReference().getMaxX() + 30.0;
                d3 = d / 2.0 - productArray.getFullBoundsReference().getHeight() / 2.0;
                productArray.setOffset(d2, d3);
            }
            CoefficientNode coefficientNode = null;
            coefficientNode = new CoefficientNode(reactantArray[i].getCoefficient());
            this.addChild(coefficientNode);
            if (productArray == null) {
                coefficientNode.setOffset(0.0, 0.0);
            } else {
                d2 = productArray.getFullBoundsReference().getMaxX() + 30.0;
                d3 = 0.0;
                coefficientNode.setOffset(d2, d3);
            }
            pNode = new NameNode(reactantArray[i].getName());
            this.addChild(pNode);
            if (coefficientNode == null) {
                if (productArray == null) {
                    pNode.setOffset(0.0, 0.0);
                } else {
                    d2 = productArray.getFullBoundsReference().getMaxX() + 30.0;
                    d3 = 0.0;
                    pNode.setOffset(d2, d3);
                }
            } else {
                d2 = coefficientNode.getFullBoundsReference().getMaxX() + 10.0;
                d3 = 0.0;
                pNode.setOffset(d2, d3);
            }
            pNode2 = pNode;
        }
        RightArrowNode rightArrowNode = new RightArrowNode();
        this.addChild(rightArrowNode);
        d2 = pNode2.getFullBoundsReference().getMaxX() + 20.0;
        d3 = d / 2.0;
        rightArrowNode.setOffset(d2, d3);
        pNode2 = rightArrowNode;
        productArray = this.reaction.getProducts();
        for (int i = 0; i < productArray.length; ++i) {
            pNode = null;
            if (i > 0) {
                pNode = new PlusNode();
                this.addChild(pNode);
                d2 = pNode2.getFullBoundsReference().getMaxX() + 30.0;
                d3 = d / 2.0 - pNode.getFullBoundsReference().getHeight() / 2.0;
                pNode.setOffset(d2, d3);
            }
            CoefficientNode coefficientNode = null;
            coefficientNode = new CoefficientNode(productArray[i].getCoefficient());
            this.addChild(coefficientNode);
            if (pNode == null) {
                d2 = rightArrowNode.getFullBoundsReference().getMaxX() + 20.0;
                d3 = 0.0;
                coefficientNode.setOffset(d2, d3);
            } else {
                d2 = pNode.getFullBoundsReference().getMaxX() + 30.0;
                d3 = 0.0;
                coefficientNode.setOffset(d2, d3);
            }
            NameNode nameNode = new NameNode(productArray[i].getName());
            this.addChild(nameNode);
            if (coefficientNode == null) {
                if (pNode == null) {
                    d2 = rightArrowNode.getFullBoundsReference().getMaxX() + 20.0;
                    d3 = 0.0;
                    nameNode.setOffset(d2, d3);
                } else {
                    d2 = pNode.getFullBoundsReference().getMaxX() + 30.0;
                    d3 = 0.0;
                    nameNode.setOffset(d2, d3);
                }
            } else {
                d2 = coefficientNode.getFullBoundsReference().getMaxX() + 10.0;
                d3 = 0.0;
                nameNode.setOffset(d2, d3);
            }
            pNode2 = nameNode;
        }
    }

    private static class CoefficientNode
    extends PComposite {
        public CoefficientNode(int n) {
            PText pText = new PText(String.valueOf(n));
            pText.setFont(FONT);
            pText.setTextPaint(COEFFICIENT_COLOR);
            this.addChild(pText);
            double d = pText.getFullBoundsReference().getWidth() + 10.0;
            double d2 = pText.getFullBoundsReference().getHeight() + 10.0;
            PPath pPath = new PPath(new Rectangle2D.Double(-5.0, -5.0, d, d2));
            pPath.setStroke(COEFFICIENT_BORDER_STROKE);
            pPath.setStrokePaint(COEFFICIENT_BORDER_COLOR);
            pText.setOffset(0.0, 0.0);
            pPath.setOffset(0.0, 0.0);
        }
    }

    private static class NameNode
    extends HTMLNode {
        public NameNode(String string) {
            super(HTMLUtils.toHTMLString(string), NAME_COLOR, FONT);
        }
    }
}

