/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.reactantsproductsandleftovers.view.game;

import edu.colorado.phet.common.games.GameScoreboardNode;
import edu.colorado.phet.reactantsproductsandleftovers.module.game.GameModel;
import java.text.DecimalFormat;
import java.text.NumberFormat;

public class RPALScoreboardNode
extends GameScoreboardNode {
    private static final NumberFormat POINTS_FORMAT = new DecimalFormat("0.#");

    public RPALScoreboardNode(final GameModel gameModel) {
        super(gameModel.getGameSettings().level.getMax(), GameModel.getPerfectScore(), POINTS_FORMAT);
        gameModel.addGameListener(new GameModel.GameAdapter(){

            public void levelChanged() {
                RPALScoreboardNode.this.setLevel(gameModel.getLevel());
            }

            public void pointsChanged() {
                RPALScoreboardNode.this.setScore(gameModel.getPoints());
            }

            public void timerVisibleChanged() {
                RPALScoreboardNode.this.setTimerVisible(gameModel.isTimerVisible());
                if (gameModel.isTimerVisible()) {
                    RPALScoreboardNode.this.setTime(gameModel.getTime());
                }
            }

            public void timeChanged() {
                RPALScoreboardNode.this.setTime(gameModel.getTime());
            }

            public void gameStarted() {
                RPALScoreboardNode.this.setConfirmNewGame(true);
            }

            public void gameCompleted() {
                RPALScoreboardNode.this.setConfirmNewGame(false);
            }
        });
        this.addGameScoreboardListener(new GameScoreboardNode.GameScoreboardListener(){

            public void newGamePressed() {
                gameModel.newGame();
            }
        });
        this.setScore(gameModel.getPoints());
        this.setLevel(gameModel.getLevel());
        this.setTimerVisible(gameModel.isTimerVisible());
        this.setTime(gameModel.getTime());
    }
}

