/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.reactantsproductsandleftovers.view.game;

import edu.colorado.phet.common.phetcommon.application.PhetApplicationConfig;
import edu.colorado.phet.common.phetcommon.model.clock.ClockAdapter;
import edu.colorado.phet.common.phetcommon.model.clock.ClockEvent;
import edu.colorado.phet.common.phetcommon.model.clock.ConstantDtClock;
import edu.colorado.phet.common.phetcommon.util.IntegerRange;
import edu.colorado.phet.common.phetcommon.view.controls.valuecontrol.LinearValueControl;
import edu.colorado.phet.common.phetcommon.view.util.EasyGridBagLayout;
import edu.colorado.phet.common.piccolophet.PhetPCanvas;
import edu.colorado.phet.common.piccolophet.PhetPNode;
import edu.colorado.phet.common.piccolophet.nodes.FaceNode;
import edu.colorado.phet.reactantsproductsandleftovers.RPALColors;
import edu.colorado.phet.reactantsproductsandleftovers.RPALConstants;
import edu.colorado.phet.reactantsproductsandleftovers.RPALImages;
import edu.colorado.phet.reactantsproductsandleftovers.model.Reactant;
import edu.colorado.phet.reactantsproductsandleftovers.model.Substance;
import edu.colorado.phet.reactantsproductsandleftovers.module.sandwichshop.SandwichShopModel;
import edu.umd.cs.piccolo.nodes.PImage;
import edu.umd.cs.piccolo.util.PBounds;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Image;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.geom.Dimension2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBox;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.border.EmptyBorder;
import javax.swing.border.TitledBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class GameRewardNode
extends PhetPNode {
    private final ConstantDtClock clock;
    private final ArrayList<Image> images;
    private final Image faceImage;
    private final SandwichShopModel sandwichShopModel;
    private int population;
    private int motionDelta;
    private IMotionStrategy motionStrategy;

    public GameRewardNode() {
        this(new PBounds(0.0, 0.0, 100.0, 100.0), 100, 5);
    }

    /*
     * WARNING - void declaration
     */
    public GameRewardNode(PBounds pBounds, int n, int n2) {
        void var8_17;
        void var8_15;
        this.setPickable(false);
        this.setChildrenPickable(false);
        this.population = n;
        this.motionDelta = n2;
        this.motionStrategy = new FallingMotionStrategy();
        this.clock = new ConstantDtClock(60, 1.0);
        this.clock.pause();
        this.sandwichShopModel = new SandwichShopModel();
        SandwichShopModel.SandwichReaction sandwichReaction = null;
        for (SandwichShopModel.SandwichReaction object : this.sandwichShopModel.getReactions()) {
            if (sandwichReaction != null && object.getNumberOfReactants() <= sandwichReaction.getNumberOfReactants()) continue;
            sandwichReaction = object;
        }
        this.sandwichShopModel.setReaction(sandwichReaction);
        for (Reactant reactant : this.sandwichShopModel.getReaction().getReactants()) {
            reactant.setCoefficient(SandwichShopModel.getCoefficientRange().getMax());
        }
        this.images = new ArrayList();
        for (Image image : RPALImages.ALL_MOLECULES) {
            this.images.add(image);
        }
        FaceNode faceNode = new FaceNode(40.0);
        this.faceImage = faceNode.toImage();
        this.images.add(this.faceImage);
        Substance[] substanceArray = this.sandwichShopModel.getReaction().getReactants();
        int n3 = substanceArray.length;
        boolean bl = false;
        while (var8_15 < n3) {
            Reactant reactant = substanceArray[var8_15];
            this.images.add(reactant.getImage());
            ++var8_15;
        }
        substanceArray = this.sandwichShopModel.getReaction().getProducts();
        n3 = substanceArray.length;
        boolean bl2 = false;
        while (var8_17 < n3) {
            Substance substance = substanceArray[var8_17];
            this.images.add(substance.getImage());
            ++var8_17;
        }
        this.clock.addClockListener(new ClockAdapter(){

            public void clockTicked(ClockEvent clockEvent) {
                GameRewardNode.this.step();
            }
        });
        this.setBounds(pBounds);
    }

    public void setLevel(int n, boolean bl) {
        block6: {
            block5: {
                if (!bl) break block5;
                this.setClockDelay(40);
                this.setPopulation(200);
                this.setMotionDelta(10);
                switch (n) {
                    case 1: {
                        this.setMoleculesVisible(true);
                        this.setSmileyFacesVisible(false);
                        this.setSandwichesVisible(false);
                        break block6;
                    }
                    case 2: {
                        this.setMoleculesVisible(false);
                        this.setSmileyFacesVisible(true);
                        this.setSandwichesVisible(false);
                        break block6;
                    }
                    case 3: {
                        this.setMoleculesVisible(false);
                        this.setSmileyFacesVisible(false);
                        this.setSandwichesVisible(true);
                        break block6;
                    }
                    default: {
                        throw new IllegalArgumentException("unsupported level: " + n);
                    }
                }
            }
            this.setMoleculesVisible(false);
            this.setSmileyFacesVisible(false);
            this.setSandwichesVisible(false);
            this.setClockDelay(40);
            this.setPopulation(50);
            this.setMotionDelta(2);
        }
    }

    public boolean setBounds(Rectangle2D rectangle2D) {
        if (rectangle2D.isEmpty()) {
            throw new IllegalArgumentException("bounds are empty");
        }
        boolean bl = false;
        if (!rectangle2D.equals(this.getBounds())) {
            bl = super.setBounds(rectangle2D);
            this.updateImages(true);
        }
        return bl;
    }

    private void setClockDelay(int n) {
        this.clock.setDelay(n);
    }

    private int getClockDelay() {
        return this.clock.getDelay();
    }

    private void setPopulation(int n) {
        if (n <= 0) {
            throw new IllegalArgumentException("population must be > 0: " + n);
        }
        if (n != this.getPopulation()) {
            this.population = n;
            this.updateImages(false);
        }
    }

    private int getPopulation() {
        return this.population;
    }

    private void setMotionDelta(int n) {
        if (n <= 0) {
            throw new IllegalArgumentException("motionDelta must be > 0: " + n);
        }
        if (n != this.getMotionDelta()) {
            this.motionDelta = n;
            for (int i = 0; i < this.getChildrenCount(); ++i) {
                if (!(this.getChild(i) instanceof MovingImageNode)) continue;
                int n2 = (int)Math.max(1.0, Math.random() * (double)n);
                ((MovingImageNode)this.getChild(i)).setMotionDelta(n2);
            }
        }
    }

    private int getMotionDelta() {
        return this.motionDelta;
    }

    private void setSmileyFacesVisible(boolean bl) {
        if (bl != this.isSmileyFacesVisible()) {
            if (bl) {
                this.images.add(this.faceImage);
            } else {
                this.images.remove(this.faceImage);
            }
            this.updateImages(true);
        }
    }

    private boolean isSmileyFacesVisible() {
        return this.images.contains(this.faceImage);
    }

    private void setSandwichesVisible(boolean bl) {
        if (bl != this.isSandwichesVisible()) {
            if (bl) {
                for (Reactant substance : this.sandwichShopModel.getReaction().getReactants()) {
                    this.images.add(substance.getImage());
                }
                for (Substance substance : this.sandwichShopModel.getReaction().getProducts()) {
                    this.images.add(substance.getImage());
                }
            } else {
                for (Reactant reactant : this.sandwichShopModel.getReaction().getReactants()) {
                    this.images.remove(reactant.getImage());
                }
                for (Substance substance : this.sandwichShopModel.getReaction().getProducts()) {
                    this.images.remove(substance.getImage());
                }
            }
            this.updateImages(true);
        }
    }

    private boolean isSandwichesVisible() {
        return this.images.contains(this.sandwichShopModel.getReaction().getProduct(0).getImage());
    }

    private void setMoleculesVisible(boolean bl) {
        if (bl != this.isMoleculesVisible()) {
            if (bl) {
                for (Image image : RPALImages.ALL_MOLECULES) {
                    this.images.add(image);
                }
            } else {
                for (Image image : RPALImages.ALL_MOLECULES) {
                    this.images.remove(image);
                }
            }
            this.updateImages(true);
        }
    }

    private boolean isMoleculesVisible() {
        return this.images.contains(RPALImages.ALL_MOLECULES[0]);
    }

    private void setMotionStrategy(IMotionStrategy iMotionStrategy) {
        this.motionStrategy = iMotionStrategy;
    }

    private void updateImages(boolean bl) {
        block5: {
            if (bl) {
                this.removeAllChildren();
            }
            if (this.images.size() <= 0) break block5;
            if (this.getChildrenCount() > this.population) {
                while (this.getChildrenCount() > this.population) {
                    this.removeChild(this.getChildrenCount() - 1);
                }
            } else {
                while (this.getChildrenCount() < this.population) {
                    this.addRandomNode();
                }
            }
        }
    }

    private void addRandomNode() {
        int n = (int)Math.max(1.0, Math.random() * (double)this.motionDelta);
        int n2 = (int)(Math.random() * (double)this.images.size());
        MovingImageNode movingImageNode = new MovingImageNode(this.images.get(n2), n);
        this.addChild(movingImageNode);
        PBounds pBounds = this.getBoundsReference();
        Point2D point2D = this.getRandomPoint(pBounds);
        double d = point2D.getX() - movingImageNode.getFullBoundsReference().getWidth() / 2.0;
        double d2 = point2D.getY() - movingImageNode.getFullBoundsReference().getHeight() / 2.0;
        movingImageNode.setOffset(d, d2);
    }

    private Point2D getRandomPoint(PBounds pBounds) {
        double d = pBounds.getX() + Math.random() * pBounds.getWidth();
        double d2 = pBounds.getY() + Math.random() * pBounds.getHeight();
        return new Point2D.Double(d, d2);
    }

    public void setVisible(boolean bl) {
        super.setVisible(bl);
        if (bl) {
            this.play();
        } else {
            this.pause();
        }
    }

    public void play() {
        this.clock.start();
    }

    public void pause() {
        this.clock.pause();
    }

    public boolean isRunning() {
        return this.clock.isRunning();
    }

    private void step() {
        PBounds pBounds = this.getBoundsReference();
        for (int i = 0; i < this.getChildrenCount(); ++i) {
            if (!(this.getChild(i) instanceof MovingImageNode)) continue;
            this.motionStrategy.step((MovingImageNode)this.getChild(i), pBounds);
        }
    }

    public static void main(String[] stringArray) {
        IntegerRange integerRange = new IntegerRange(10, 200, 60);
        IntegerRange integerRange2 = new IntegerRange(50, 1000, 500);
        IntegerRange integerRange3 = new IntegerRange(1, 20, 5);
        PBounds pBounds = new PBounds(0.0, 0.0, 100.0, 100.0);
        final GameRewardNode gameRewardNode = new GameRewardNode(pBounds, integerRange2.getDefault(), integerRange3.getDefault());
        gameRewardNode.play();
        PhetPCanvas phetPCanvas = new PhetPCanvas(RPALConstants.CANVAS_RENDERING_SIZE){

            protected void updateLayout() {
                Dimension2D dimension2D = this.getWorldSize();
                if (dimension2D.getWidth() > 0.0 && dimension2D.getHeight() > 0.0) {
                    PBounds pBounds = new PBounds(0.0, 0.0, dimension2D.getWidth(), dimension2D.getHeight());
                    gameRewardNode.setBounds(pBounds);
                }
            }
        };
        phetPCanvas.setBackground(RPALColors.COLOR_SCHEME.get().canvasBackground);
        phetPCanvas.addWorldChild(gameRewardNode);
        final JitteryMotionStrategy jitteryMotionStrategy = new JitteryMotionStrategy();
        final FallingMotionStrategy fallingMotionStrategy = new FallingMotionStrategy();
        JRadioButton jRadioButton = new JRadioButton("jittery");
        jRadioButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                gameRewardNode.setMotionStrategy(jitteryMotionStrategy);
            }
        });
        JRadioButton jRadioButton2 = new JRadioButton("falling");
        jRadioButton2.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                gameRewardNode.setMotionStrategy(fallingMotionStrategy);
            }
        });
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(jRadioButton);
        buttonGroup.add(jRadioButton2);
        gameRewardNode.setMotionStrategy(fallingMotionStrategy);
        jRadioButton2.setSelected(true);
        JPanel jPanel = new JPanel();
        jPanel.setBorder(new TitledBorder("Motion Strategy"));
        EasyGridBagLayout easyGridBagLayout = new EasyGridBagLayout(jPanel);
        jPanel.setLayout(easyGridBagLayout);
        int n = 0;
        int n2 = 0;
        easyGridBagLayout.addComponent(jRadioButton, n, n2++);
        easyGridBagLayout.addComponent(jRadioButton2, n, n2++);
        final LinearValueControl linearValueControl = new LinearValueControl(integerRange.getMin(), integerRange.getMax(), "clock delay:", "##0", "ms");
        linearValueControl.setToolTipText("how frequently the simulation clock ticks");
        linearValueControl.setValue(gameRewardNode.getClockDelay());
        linearValueControl.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                gameRewardNode.setClockDelay((int)linearValueControl.getValue());
            }
        });
        final LinearValueControl linearValueControl2 = new LinearValueControl(integerRange2.getMin(), integerRange2.getMax(), "population:", "##0", "");
        linearValueControl2.setValue(integerRange2.getDefault());
        linearValueControl2.setToolTipText("how many images are in the play area");
        linearValueControl2.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                gameRewardNode.setPopulation((int)linearValueControl2.getValue());
            }
        });
        final LinearValueControl linearValueControl3 = new LinearValueControl(integerRange3.getMin(), integerRange3.getMax(), "motion delta:", "##0", "pixels");
        linearValueControl3.setValue(integerRange3.getDefault());
        linearValueControl3.setToolTipText("how far images move each time the clock ticks");
        linearValueControl3.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                gameRewardNode.setMotionDelta((int)linearValueControl3.getValue());
            }
        });
        final JCheckBox jCheckBox = new JCheckBox("show molecules");
        jCheckBox.setSelected(gameRewardNode.isMoleculesVisible());
        jCheckBox.setToolTipText("determines whether molecules will be shown");
        jCheckBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                gameRewardNode.setMoleculesVisible(jCheckBox.isSelected());
            }
        });
        final JCheckBox jCheckBox2 = new JCheckBox("show smiley faces");
        jCheckBox2.setSelected(gameRewardNode.isSmileyFacesVisible());
        jCheckBox2.setToolTipText("determines whether smiley faces will be shown");
        jCheckBox2.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                gameRewardNode.setSmileyFacesVisible(jCheckBox2.isSelected());
            }
        });
        final JCheckBox jCheckBox3 = new JCheckBox("show sandwiches");
        jCheckBox3.setSelected(gameRewardNode.isSandwichesVisible());
        jCheckBox3.setToolTipText("determines whether sandwiches will be shown");
        jCheckBox3.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                gameRewardNode.setSandwichesVisible(jCheckBox3.isSelected());
            }
        });
        JPanel jPanel2 = new JPanel();
        jPanel2.setBorder(new TitledBorder("Developer Controls"));
        EasyGridBagLayout easyGridBagLayout2 = new EasyGridBagLayout(jPanel2);
        jPanel2.setLayout(easyGridBagLayout2);
        n = 0;
        n2 = 0;
        easyGridBagLayout2.addComponent(jPanel, n++, n2);
        easyGridBagLayout2.addComponent(linearValueControl, n++, n2);
        easyGridBagLayout2.addComponent(linearValueControl2, n++, n2);
        easyGridBagLayout2.addComponent(linearValueControl3, n++, n2);
        easyGridBagLayout2.addComponent(jCheckBox, n++, n2);
        easyGridBagLayout2.addComponent(jCheckBox2, n++, n2);
        easyGridBagLayout2.addComponent(jCheckBox3, n++, n2);
        JPanel jPanel3 = new JPanel();
        jPanel3.setBorder(new EmptyBorder(10, 10, 10, 10));
        jPanel3.add(jPanel2);
        JPanel jPanel4 = new JPanel(new BorderLayout());
        jPanel4.add((Component)phetPCanvas, "Center");
        jPanel4.add((Component)jPanel3, "East");
        JFrame jFrame = new JFrame("Game Reward test");
        jFrame.setContentPane(jPanel4);
        jFrame.setDefaultCloseOperation(3);
        PhetApplicationConfig.DEFAULT_FRAME_SETUP.initialize(jFrame);
        jFrame.setVisible(true);
    }

    public static class FallingMotionStrategy
    implements IMotionStrategy {
        public void step(MovingImageNode movingImageNode, PBounds pBounds) {
            double d = movingImageNode.getYOffset() + (double)movingImageNode.getMotionDelta();
            if (d > pBounds.getMaxY()) {
                d = pBounds.getMinY() - movingImageNode.getFullBoundsReference().getHeight();
            }
            movingImageNode.setOffset(movingImageNode.getXOffset(), d);
        }
    }

    public static interface IMotionStrategy {
        public void step(MovingImageNode var1, PBounds var2);
    }

    public static class JitteryMotionStrategy
    implements IMotionStrategy {
        public void step(MovingImageNode movingImageNode, PBounds pBounds) {
            double d = movingImageNode.getXOffset() + (double)(this.getRandomDirection() * movingImageNode.getMotionDelta());
            double d2 = movingImageNode.getYOffset() + (double)(this.getRandomDirection() * movingImageNode.getMotionDelta());
            d = Math.max(pBounds.getMinX(), Math.min(d, pBounds.getMaxX()));
            d2 = Math.max(pBounds.getMinY(), Math.min(d2, pBounds.getMaxY()));
            movingImageNode.setOffset(d, d2);
        }

        private int getRandomDirection() {
            return Math.random() > 0.5 ? 1 : -1;
        }
    }

    private static class MovingImageNode
    extends PImage {
        private int motionDelta;

        public MovingImageNode(Image image, int n) {
            super(image);
            this.motionDelta = n;
        }

        public int getMotionDelta() {
            return this.motionDelta;
        }

        public void setMotionDelta(int n) {
            this.motionDelta = n;
        }
    }
}

