/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.reactantsproductsandleftovers.view.game;

import edu.colorado.phet.reactantsproductsandleftovers.RPALStrings;
import edu.colorado.phet.reactantsproductsandleftovers.controls.QuantityValueNode;
import edu.colorado.phet.reactantsproductsandleftovers.model.ChemicalReaction;
import edu.colorado.phet.reactantsproductsandleftovers.model.Reactant;
import edu.colorado.phet.reactantsproductsandleftovers.module.game.GameChallenge;
import edu.colorado.phet.reactantsproductsandleftovers.module.game.GameGuess;
import edu.colorado.phet.reactantsproductsandleftovers.module.game.GameModel;
import edu.colorado.phet.reactantsproductsandleftovers.view.AbstractBeforeNode;
import edu.colorado.phet.reactantsproductsandleftovers.view.GridLayoutNode;
import edu.colorado.phet.reactantsproductsandleftovers.view.ImageLayoutNode;
import edu.colorado.phet.reactantsproductsandleftovers.view.SubstanceImageNode;
import edu.colorado.phet.reactantsproductsandleftovers.view.game.GameMessageNode;
import edu.umd.cs.piccolo.util.PDimension;
import java.awt.Color;
import java.util.ArrayList;

public class GameBeforeNode
extends AbstractBeforeNode {
    private final GameModel model;
    private final GameModel.GameListener gameListener;
    private final ImageLayoutNode guessImagesNode;
    private final ArrayList<ArrayList<SubstanceImageNode>> reactantImageNodeLists;
    private final GameMessageNode moleculesHiddenNode;
    private final GameMessageNode numbersHiddenNode;

    public GameBeforeNode(GameModel gameModel, PDimension pDimension) {
        super(RPALStrings.LABEL_BEFORE_REACTION, pDimension, gameModel.getChallenge().getReaction(), GameModel.getQuantityRange(), true, new GridLayoutNode(pDimension));
        this.model = gameModel;
        this.gameListener = new GameModel.GameAdapter(){

            public void guessChanged() {
                GameBeforeNode.this.updateGuessImages();
            }
        };
        gameModel.addGameListener(this.gameListener);
        ChemicalReaction chemicalReaction = gameModel.getChallenge().getReaction();
        this.reactantImageNodeLists = new ArrayList();
        for (int i = 0; i < chemicalReaction.getNumberOfReactants(); ++i) {
            this.reactantImageNodeLists.add(new ArrayList());
        }
        this.guessImagesNode = new GridLayoutNode(pDimension);
        this.updateGuessImages();
        this.addChild(this.guessImagesNode);
        this.moleculesHiddenNode = new GameMessageNode(RPALStrings.MESSAGE_MOLECULES_HIDDEN, Color.BLACK, 28);
        this.addChild(this.moleculesHiddenNode);
        double d = (pDimension.getWidth() - this.moleculesHiddenNode.getFullBoundsReference().getWidth()) / 2.0;
        double d2 = (pDimension.getHeight() - this.moleculesHiddenNode.getFullBoundsReference().getHeight()) / 2.0;
        this.moleculesHiddenNode.setOffset(d, d2);
        this.numbersHiddenNode = new GameMessageNode(RPALStrings.MESSAGE_NUMBERS_HIDDEN, Color.BLACK, 28);
        this.addChild(this.numbersHiddenNode);
        d = (pDimension.getWidth() - this.numbersHiddenNode.getFullBoundsReference().getWidth()) / 2.0;
        d2 = pDimension.getHeight() + 35.0;
        this.numbersHiddenNode.setOffset(d, d2);
        GameChallenge gameChallenge = gameModel.getChallenge();
        if (gameChallenge.getChallengeType() == GameChallenge.ChallengeType.BEFORE) {
            this.showGuess(true);
        } else {
            this.showAnswer(gameChallenge.isMoleculesVisible(), gameChallenge.isNumbersVisible());
        }
    }

    public void cleanup() {
        super.cleanup();
        this.model.removeGameListener(this.gameListener);
    }

    public void showAnswer() {
        this.showAnswer(true, true);
    }

    public void showAnswer(boolean bl, boolean bl2) {
        assert (bl || bl2);
        ChemicalReaction chemicalReaction = this.model.getChallenge().getReaction();
        ArrayList<QuantityValueNode> arrayList = this.getReactantValueNodes();
        for (int i = 0; i < arrayList.size(); ++i) {
            QuantityValueNode quantityValueNode = arrayList.get(i);
            quantityValueNode.setEditable(false);
            quantityValueNode.setSubstance(chemicalReaction.getReactant(i));
        }
        this.guessImagesNode.setVisible(false);
        this.setReactionImagesVisible(bl);
        this.setValueNodeImagesVisible(bl);
        this.moleculesHiddenNode.setVisible(!bl);
        this.setNumbersVisible(bl2);
        this.numbersHiddenNode.setVisible(!bl2);
    }

    public void showGuess(boolean bl) {
        GameGuess gameGuess = this.model.getChallenge().getGuess();
        ArrayList<QuantityValueNode> arrayList = this.getReactantValueNodes();
        for (int i = 0; i < arrayList.size(); ++i) {
            QuantityValueNode quantityValueNode = arrayList.get(i);
            quantityValueNode.setEditable(bl);
            quantityValueNode.setSubstance(gameGuess.getReactant(i));
        }
        this.guessImagesNode.setVisible(true);
        this.moleculesHiddenNode.setVisible(false);
        this.setValueNodeImagesVisible(true);
        this.setReactionImagesVisible(false);
        this.setNumbersVisible(true);
        this.numbersHiddenNode.setVisible(false);
    }

    private void updateGuessImages() {
        SubstanceImageNode substanceImageNode;
        ArrayList<SubstanceImageNode> arrayList;
        Reactant reactant;
        int n;
        GameGuess gameGuess = this.model.getChallenge().getGuess();
        ArrayList<QuantityValueNode> arrayList2 = this.getReactantValueNodes();
        Reactant[] reactantArray = gameGuess.getReactants();
        for (n = 0; n < reactantArray.length; ++n) {
            reactant = reactantArray[n];
            arrayList = this.reactantImageNodeLists.get(n);
            while (reactant.getQuantity() < arrayList.size()) {
                substanceImageNode = arrayList.get(arrayList.size() - 1);
                substanceImageNode.cleanup();
                this.guessImagesNode.removeNode(substanceImageNode);
                arrayList.remove(substanceImageNode);
            }
        }
        for (n = 0; n < reactantArray.length; ++n) {
            reactant = reactantArray[n];
            arrayList = this.reactantImageNodeLists.get(n);
            while (reactant.getQuantity() > arrayList.size()) {
                substanceImageNode = new SubstanceImageNode(reactant);
                substanceImageNode.scale(1.0);
                arrayList.add(substanceImageNode);
                this.guessImagesNode.addNode(substanceImageNode, arrayList2.get(n));
            }
        }
    }
}

