/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.reactantsproductsandleftovers.view.game;

import edu.colorado.phet.reactantsproductsandleftovers.RPALStrings;
import edu.colorado.phet.reactantsproductsandleftovers.controls.LeftoversValueNode;
import edu.colorado.phet.reactantsproductsandleftovers.controls.QuantityValueNode;
import edu.colorado.phet.reactantsproductsandleftovers.model.ChemicalReaction;
import edu.colorado.phet.reactantsproductsandleftovers.model.Product;
import edu.colorado.phet.reactantsproductsandleftovers.model.Reactant;
import edu.colorado.phet.reactantsproductsandleftovers.model.Substance;
import edu.colorado.phet.reactantsproductsandleftovers.module.game.GameChallenge;
import edu.colorado.phet.reactantsproductsandleftovers.module.game.GameGuess;
import edu.colorado.phet.reactantsproductsandleftovers.module.game.GameModel;
import edu.colorado.phet.reactantsproductsandleftovers.view.AbstractAfterNode;
import edu.colorado.phet.reactantsproductsandleftovers.view.GridLayoutNode;
import edu.colorado.phet.reactantsproductsandleftovers.view.ImageLayoutNode;
import edu.colorado.phet.reactantsproductsandleftovers.view.SubstanceImageNode;
import edu.colorado.phet.reactantsproductsandleftovers.view.game.GameMessageNode;
import edu.umd.cs.piccolo.PNode;
import edu.umd.cs.piccolo.util.PDimension;
import java.awt.Color;
import java.util.ArrayList;

public class GameAfterNode
extends AbstractAfterNode {
    private final GameModel model;
    private final GameModel.GameListener gameListener;
    private final ImageLayoutNode guessImagesNode;
    private final ArrayList<ArrayList<SubstanceImageNode>> productImageNodeLists;
    private final ArrayList<ArrayList<SubstanceImageNode>> leftoverImageNodeLists;
    private final GameMessageNode moleculesHiddenNode;
    private final GameMessageNode numbersHiddenNode;

    public GameAfterNode(GameModel gameModel, PDimension pDimension) {
        super(RPALStrings.LABEL_AFTER_REACTION, pDimension, gameModel.getChallenge().getReaction(), GameModel.getQuantityRange(), true, new GridLayoutNode(pDimension));
        int n;
        this.model = gameModel;
        this.gameListener = new GameModel.GameAdapter(){

            public void guessChanged() {
                GameAfterNode.this.updateGuessImages();
            }
        };
        gameModel.addGameListener(this.gameListener);
        ChemicalReaction chemicalReaction = gameModel.getChallenge().getReaction();
        this.productImageNodeLists = new ArrayList();
        for (n = 0; n < chemicalReaction.getNumberOfProducts(); ++n) {
            this.productImageNodeLists.add(new ArrayList());
        }
        this.leftoverImageNodeLists = new ArrayList();
        for (n = 0; n < chemicalReaction.getNumberOfReactants(); ++n) {
            this.leftoverImageNodeLists.add(new ArrayList());
        }
        this.guessImagesNode = new GridLayoutNode(pDimension);
        this.updateGuessImages();
        this.addChild(this.guessImagesNode);
        this.moleculesHiddenNode = new GameMessageNode(RPALStrings.MESSAGE_MOLECULES_HIDDEN, Color.BLACK, 28);
        this.addChild(this.moleculesHiddenNode);
        double d = (pDimension.getWidth() - this.moleculesHiddenNode.getFullBoundsReference().getWidth()) / 2.0;
        double d2 = (pDimension.getHeight() - this.moleculesHiddenNode.getFullBoundsReference().getHeight()) / 2.0;
        this.moleculesHiddenNode.setOffset(d, d2);
        this.numbersHiddenNode = new GameMessageNode(RPALStrings.MESSAGE_NUMBERS_HIDDEN, Color.BLACK, 28);
        this.addChild(this.numbersHiddenNode);
        d = (pDimension.getWidth() - this.numbersHiddenNode.getFullBoundsReference().getWidth()) / 2.0;
        d2 = pDimension.getHeight() + 35.0;
        this.numbersHiddenNode.setOffset(d, d2);
        GameChallenge gameChallenge = gameModel.getChallenge();
        if (gameChallenge.getChallengeType() == GameChallenge.ChallengeType.AFTER) {
            this.showGuess(true);
        } else {
            this.showAnswer(gameChallenge.isMoleculesVisible(), gameChallenge.isNumbersVisible());
        }
    }

    public void cleanup() {
        super.cleanup();
        this.model.removeGameListener(this.gameListener);
    }

    public void showAnswer() {
        this.showAnswer(true, true);
    }

    public void showAnswer(boolean bl, boolean bl2) {
        assert (bl || bl2);
        ChemicalReaction chemicalReaction = this.model.getChallenge().getReaction();
        ArrayList<QuantityValueNode> arrayList = this.getProductValueNodes();
        for (int i = 0; i < arrayList.size(); ++i) {
            QuantityValueNode quantityValueNode = arrayList.get(i);
            quantityValueNode.setEditable(false);
            quantityValueNode.setSubstance(chemicalReaction.getProduct(i));
        }
        ArrayList<LeftoversValueNode> arrayList2 = this.getLeftoverValueNodes();
        for (int i = 0; i < arrayList2.size(); ++i) {
            LeftoversValueNode leftoversValueNode = arrayList2.get(i);
            leftoversValueNode.setEditable(false);
            leftoversValueNode.setReactant(chemicalReaction.getReactant(i));
        }
        this.guessImagesNode.setVisible(false);
        this.setReactionImagesVisible(bl);
        this.setValueNodeImagesVisible(bl);
        this.moleculesHiddenNode.setVisible(!bl);
        this.setNumbersVisible(bl2);
        this.numbersHiddenNode.setVisible(!bl2);
    }

    public void showGuess(boolean bl) {
        GameGuess gameGuess = this.model.getChallenge().getGuess();
        ArrayList<QuantityValueNode> arrayList = this.getProductValueNodes();
        for (int i = 0; i < arrayList.size(); ++i) {
            QuantityValueNode quantityValueNode = arrayList.get(i);
            quantityValueNode.setEditable(bl);
            quantityValueNode.setSubstance(gameGuess.getProduct(i));
        }
        ArrayList<LeftoversValueNode> arrayList2 = this.getLeftoverValueNodes();
        for (int i = 0; i < arrayList2.size(); ++i) {
            LeftoversValueNode leftoversValueNode = arrayList2.get(i);
            leftoversValueNode.setEditable(bl);
            leftoversValueNode.setReactant(gameGuess.getReactant(i));
        }
        this.guessImagesNode.setVisible(true);
        this.moleculesHiddenNode.setVisible(false);
        this.setValueNodeImagesVisible(true);
        this.setReactionImagesVisible(false);
        this.setNumbersVisible(true);
        this.numbersHiddenNode.setVisible(false);
    }

    private void updateGuessImages() {
        Cloneable cloneable;
        Object object;
        Cloneable cloneable2;
        Object object2;
        GameGuess gameGuess = this.model.getChallenge().getGuess();
        Product[] productArray = gameGuess.getProducts();
        for (int i = 0; i < productArray.length; ++i) {
            Product product = productArray[i];
            object2 = this.productImageNodeLists.get(i);
            if (product.getQuantity() >= ((ArrayList)object2).size()) continue;
            while (product.getQuantity() < ((ArrayList)object2).size()) {
                cloneable2 = (SubstanceImageNode)((ArrayList)object2).get(((ArrayList)object2).size() - 1);
                ((SubstanceImageNode)cloneable2).cleanup();
                this.guessImagesNode.removeNode((SubstanceImageNode)cloneable2);
                ((ArrayList)object2).remove(cloneable2);
            }
        }
        Reactant[] reactantArray = gameGuess.getReactants();
        for (int i = 0; i < reactantArray.length; ++i) {
            object2 = reactantArray[i];
            cloneable2 = this.leftoverImageNodeLists.get(i);
            if (((Reactant)object2).getLeftovers() >= ((ArrayList)cloneable2).size()) continue;
            while (((Reactant)object2).getLeftovers() < ((ArrayList)cloneable2).size()) {
                object = (SubstanceImageNode)((ArrayList)cloneable2).get(((ArrayList)cloneable2).size() - 1);
                ((SubstanceImageNode)object).cleanup();
                this.guessImagesNode.removeNode((SubstanceImageNode)object);
                ((ArrayList)cloneable2).remove(object);
            }
        }
        ArrayList<QuantityValueNode> arrayList = this.getProductValueNodes();
        for (int i = 0; i < productArray.length; ++i) {
            cloneable2 = this.productImageNodeLists.get(i);
            object = productArray[i];
            while (((Substance)object).getQuantity() > ((ArrayList)cloneable2).size()) {
                cloneable = new SubstanceImageNode((Substance)object);
                ((PNode)cloneable).scale(1.0);
                ((ArrayList)cloneable2).add(cloneable);
                this.guessImagesNode.addNode((SubstanceImageNode)cloneable, arrayList.get(i));
            }
        }
        ArrayList<LeftoversValueNode> arrayList2 = this.getLeftoverValueNodes();
        for (int i = 0; i < reactantArray.length; ++i) {
            object = reactantArray[i];
            cloneable = this.leftoverImageNodeLists.get(i);
            while (((Reactant)object).getLeftovers() > ((ArrayList)cloneable).size()) {
                SubstanceImageNode substanceImageNode = new SubstanceImageNode((Substance)object);
                substanceImageNode.scale(1.0);
                ((ArrayList)cloneable).add(substanceImageNode);
                this.guessImagesNode.addNode(substanceImageNode, arrayList2.get(i));
            }
        }
    }
}

