/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.reactantsproductsandleftovers.view;

import edu.colorado.phet.reactantsproductsandleftovers.controls.ValueNode;
import edu.colorado.phet.reactantsproductsandleftovers.view.ImageLayoutNode;
import edu.colorado.phet.reactantsproductsandleftovers.view.SubstanceImageNode;
import edu.umd.cs.piccolo.PNode;
import edu.umd.cs.piccolo.util.PDimension;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.HashMap;

public class StackedLayoutNode
extends ImageLayoutNode {
    private final PropertyChangeListener imageChangeListener = new PropertyChangeListener(){

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            if (propertyChangeEvent.getPropertyName().equals("image")) {
                StackedLayoutNode.this.updateLayout();
            }
        }
    };
    private final HashMap<String, ArrayList<SubstanceImageNode>> stacks = new HashMap();
    private final HashMap<String, ValueNode> valueNodes = new HashMap();

    public StackedLayoutNode(PDimension pDimension) {
        super(pDimension);
    }

    public void addNode(SubstanceImageNode substanceImageNode, ValueNode valueNode) {
        String string = substanceImageNode.getSubstance().getName();
        this.addChild(substanceImageNode);
        ArrayList<SubstanceImageNode> arrayList = this.stacks.get(string);
        if (arrayList == null) {
            arrayList = new ArrayList();
            this.stacks.put(string, arrayList);
        }
        arrayList.add(substanceImageNode);
        if (this.valueNodes.get(string) == null) {
            this.valueNodes.put(string, valueNode);
        }
        substanceImageNode.addPropertyChangeListener(this.imageChangeListener);
        this.updateLayout();
    }

    public void removeNode(SubstanceImageNode substanceImageNode) {
        this.removeChild(substanceImageNode);
        substanceImageNode.removePropertyChangeListener(this.imageChangeListener);
        ArrayList<SubstanceImageNode> arrayList = this.stacks.get(substanceImageNode.getSubstance().getName());
        arrayList.remove(substanceImageNode);
    }

    private void updateLayout() {
        for (String string : this.stacks.keySet()) {
            ArrayList<SubstanceImageNode> arrayList = this.stacks.get(string);
            PNode pNode = this.valueNodes.get(string);
            for (int i = 0; i < arrayList.size(); ++i) {
                SubstanceImageNode substanceImageNode = arrayList.get(i);
                double d = pNode.getXOffset() - substanceImageNode.getFullBoundsReference().getWidth() / 2.0;
                double d2 = this.getBoxHeight() - substanceImageNode.getFullBoundsReference().getHeight() - 7.0 - (double)i * 28.0;
                substanceImageNode.setOffset(d, d2);
            }
        }
    }
}

