/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.reactantsproductsandleftovers.view;

import edu.colorado.phet.common.phetcommon.simsharing.messages.UserComponent;
import edu.colorado.phet.common.phetcommon.simsharing.messages.UserComponentChain;
import edu.colorado.phet.common.phetcommon.util.IntegerRange;
import edu.colorado.phet.common.phetcommon.util.SimpleObserver;
import edu.colorado.phet.common.phetcommon.view.util.PhetFont;
import edu.colorado.phet.common.piccolophet.PhetPNode;
import edu.colorado.phet.reactantsproductsandleftovers.RPALColors;
import edu.colorado.phet.reactantsproductsandleftovers.RPALSimSharing;
import edu.colorado.phet.reactantsproductsandleftovers.RPALStrings;
import edu.colorado.phet.reactantsproductsandleftovers.controls.QuantityValueNode;
import edu.colorado.phet.reactantsproductsandleftovers.model.ChemicalReaction;
import edu.colorado.phet.reactantsproductsandleftovers.model.Reactant;
import edu.colorado.phet.reactantsproductsandleftovers.view.BracketedLabelNode;
import edu.colorado.phet.reactantsproductsandleftovers.view.ImageLayoutNode;
import edu.colorado.phet.reactantsproductsandleftovers.view.SubstanceImageNode;
import edu.colorado.phet.reactantsproductsandleftovers.view.TitledBoxNode;
import edu.umd.cs.piccolo.util.PDimension;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Stroke;
import java.util.ArrayList;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractBeforeNode
extends PhetPNode {
    private static final PhetFont BRACKET_FONT = new PhetFont(16);
    private static final Color BRACKET_TEXT_COLOR = Color.BLACK;
    private static final Color BRACKET_COLOR = RPALColors.COLOR_SCHEME.get().bracketColor;
    private static final Stroke BRACKET_STROKE = new BasicStroke(0.75f);
    private final ChemicalReaction reaction;
    private final ChangeListener reactionChangeListener;
    private final TitledBoxNode titledBoxNode;
    private final ArrayList<ArrayList<SubstanceImageNode>> imageNodeLists;
    private final ArrayList<QuantityValueNode> reactantValueNodes;
    private final ImageLayoutNode imageLayoutNode;

    public AbstractBeforeNode(String string, PDimension pDimension, ChemicalReaction chemicalReaction, IntegerRange integerRange, boolean bl, ImageLayoutNode imageLayoutNode) {
        Reactant[] reactantArray;
        this.reaction = chemicalReaction;
        this.reactionChangeListener = new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                AbstractBeforeNode.this.updateImages();
            }
        };
        chemicalReaction.addChangeListener(this.reactionChangeListener);
        this.imageLayoutNode = imageLayoutNode;
        this.imageNodeLists = new ArrayList();
        this.reactantValueNodes = new ArrayList();
        this.titledBoxNode = new TitledBoxNode(string, pDimension);
        this.addChild(this.titledBoxNode);
        this.addChild(imageLayoutNode);
        for (Reactant reactant : reactantArray = chemicalReaction.getReactants()) {
            this.imageNodeLists.add(new ArrayList());
            UserComponentChain userComponentChain = UserComponentChain.chain(RPALSimSharing.UserComponents.reactantSpinner, new UserComponent(reactant.getPlainTextName()));
            QuantityValueNode quantityValueNode = new QuantityValueNode(userComponentChain, reactant, integerRange, 1.0, bl);
            quantityValueNode.setEditable(true);
            this.addChild(quantityValueNode);
            this.reactantValueNodes.add(quantityValueNode);
        }
        double d = 0.0;
        double d2 = 0.0;
        this.titledBoxNode.setOffset(d, d2);
        double d3 = reactantArray.length > 2 ? 0.0 : 0.15 * pDimension.getWidth();
        double d4 = (pDimension.getWidth() - 2.0 * d3) / (double)reactantArray.length;
        d = this.titledBoxNode.getBoxNode().getFullBoundsReference().getMinX() + d3 + d4 / 2.0;
        d2 = this.titledBoxNode.getBoxNode().getFullBoundsReference().getMaxY() + 15.0;
        for (int i = 0; i < reactantArray.length; ++i) {
            this.reactantValueNodes.get(i).setOffset(d, d2);
            d += d4;
        }
        double d5 = this.reactantValueNodes.get(0).getFullBoundsReference().getMinX();
        double d6 = this.reactantValueNodes.get(this.reactantValueNodes.size() - 1).getFullBoundsReference().getMaxX();
        double d7 = d6 - d5;
        final BracketedLabelNode bracketedLabelNode = new BracketedLabelNode(RPALStrings.LABEL_REACTANTS, d7, BRACKET_FONT, BRACKET_TEXT_COLOR, BRACKET_COLOR, BRACKET_STROKE);
        this.addChild(bracketedLabelNode);
        d = d5;
        d2 = 0.0;
        for (QuantityValueNode quantityValueNode : this.reactantValueNodes) {
            d2 = Math.max(d2, quantityValueNode.getFullBoundsReference().getMaxY() + 3.0);
        }
        bracketedLabelNode.setOffset(d, d2);
        RPALColors.COLOR_SCHEME.addObserver(new SimpleObserver(){

            public void update() {
                bracketedLabelNode.setBracketStrokePaint(RPALColors.COLOR_SCHEME.get().bracketColor);
            }
        });
        this.updateImages();
    }

    public void cleanup() {
        this.reaction.removeChangeListener(this.reactionChangeListener);
        for (QuantityValueNode cloneable : this.reactantValueNodes) {
            cloneable.cleanup();
        }
        for (ArrayList arrayList : this.imageNodeLists) {
            for (SubstanceImageNode substanceImageNode : arrayList) {
                substanceImageNode.cleanup();
            }
        }
    }

    protected void setReactionImagesVisible(boolean bl) {
        this.imageLayoutNode.setVisible(bl);
    }

    protected void setValueNodeImagesVisible(boolean bl) {
        for (QuantityValueNode quantityValueNode : this.reactantValueNodes) {
            quantityValueNode.setImageVisible(bl);
        }
    }

    protected void setNumbersVisible(boolean bl) {
        for (QuantityValueNode quantityValueNode : this.reactantValueNodes) {
            quantityValueNode.setValueVisible(bl);
            quantityValueNode.setHistogramBarVisible(bl);
        }
    }

    protected ArrayList<QuantityValueNode> getReactantValueNodes() {
        return this.reactantValueNodes;
    }

    private void updateImages() {
        SubstanceImageNode substanceImageNode;
        ArrayList<SubstanceImageNode> arrayList;
        Reactant reactant;
        int n;
        Reactant[] reactantArray = this.reaction.getReactants();
        for (n = 0; n < reactantArray.length; ++n) {
            reactant = reactantArray[n];
            arrayList = this.imageNodeLists.get(n);
            while (reactant.getQuantity() < arrayList.size()) {
                substanceImageNode = arrayList.get(arrayList.size() - 1);
                substanceImageNode.cleanup();
                this.imageLayoutNode.removeNode(substanceImageNode);
                arrayList.remove(substanceImageNode);
            }
        }
        for (n = 0; n < reactantArray.length; ++n) {
            reactant = reactantArray[n];
            arrayList = this.imageNodeLists.get(n);
            while (reactant.getQuantity() > arrayList.size()) {
                substanceImageNode = new SubstanceImageNode(reactant);
                substanceImageNode.scale(1.0);
                arrayList.add(substanceImageNode);
                this.imageLayoutNode.addNode(substanceImageNode, this.reactantValueNodes.get(n));
            }
        }
    }
}

