/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.reactantsproductsandleftovers.module.sandwichshop;

import edu.colorado.phet.reactantsproductsandleftovers.RPALStrings;
import edu.colorado.phet.reactantsproductsandleftovers.model.ChemicalReaction;
import edu.colorado.phet.reactantsproductsandleftovers.model.Molecule;
import edu.colorado.phet.reactantsproductsandleftovers.model.Product;
import edu.colorado.phet.reactantsproductsandleftovers.model.RPALModel;
import edu.colorado.phet.reactantsproductsandleftovers.model.Reactant;
import edu.colorado.phet.reactantsproductsandleftovers.view.sandwich.SandwichImageFactory;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.EventListenerList;

public class SandwichShopModel
extends RPALModel {
    private static int DEFAULT_COEFFICIENT = 0;
    private static int DEFAULT_QUANTITY = 0;
    private static int DEFAULT_SANDWICH_INDEX = 0;
    private final EventListenerList listeners = new EventListenerList();
    private final SandwichReaction[] reactions = new SandwichReaction[]{new CheeseSandwichReaction(), new MeatCheeseSandwich()};
    private SandwichReaction reaction = this.reactions[DEFAULT_SANDWICH_INDEX];

    public void reset() {
        for (SandwichReaction sandwichReaction : this.reactions) {
            for (Reactant reactant : sandwichReaction.getReactants()) {
                reactant.setCoefficient(DEFAULT_COEFFICIENT);
                reactant.setQuantity(DEFAULT_QUANTITY);
            }
        }
        this.setReaction(this.reactions[DEFAULT_SANDWICH_INDEX]);
    }

    public SandwichReaction[] getReactions() {
        return this.reactions;
    }

    public void setReaction(SandwichReaction sandwichReaction) {
        this.reaction = sandwichReaction;
        this.fireStateChanged();
    }

    public SandwichReaction getReaction() {
        return this.reaction;
    }

    public void addChangeListener(ChangeListener changeListener) {
        this.listeners.add(ChangeListener.class, changeListener);
    }

    private void fireStateChanged() {
        ChangeEvent changeEvent = new ChangeEvent(this);
        for (ChangeListener changeListener : (ChangeListener[])this.listeners.getListeners(ChangeListener.class)) {
            changeListener.stateChanged(changeEvent);
        }
    }

    public static class CheeseSandwichReaction
    extends SandwichReaction {
        public CheeseSandwichReaction() {
            super(RPALStrings.RADIO_BUTTON_CHEESE_SANDWICH, "cheeseSandwich", new Reactant[]{new Reactant(DEFAULT_COEFFICIENT, new Molecule.Bread(), DEFAULT_QUANTITY), new Reactant(DEFAULT_COEFFICIENT, new Molecule.Cheese(), DEFAULT_QUANTITY)});
        }
    }

    public static class MeatCheeseSandwich
    extends SandwichReaction {
        public MeatCheeseSandwich() {
            super(RPALStrings.RADIO_BUTTON_MEAT_CHEESE_SANDWICH, "meatAndCheeseSandwich", new Reactant[]{new Reactant(DEFAULT_COEFFICIENT, new Molecule.Bread(), DEFAULT_QUANTITY), new Reactant(DEFAULT_COEFFICIENT, new Molecule.Meat(), DEFAULT_QUANTITY), new Reactant(DEFAULT_COEFFICIENT, new Molecule.Cheese(), DEFAULT_QUANTITY)});
        }
    }

    public static abstract class SandwichReaction
    extends ChemicalReaction {
        public SandwichReaction(String string, String string2, Reactant[] reactantArray) {
            super(string, string2, reactantArray, new Product[]{new Product(1, new Molecule.Sandwich(), DEFAULT_QUANTITY)});
            for (Reactant reactant : this.getReactants()) {
                reactant.addReactantChangeListener(new Reactant.ReactantChangeAdapter(){

                    public void coefficientChanged() {
                        SandwichReaction.this.updateSandwichImage();
                    }
                });
            }
            this.updateSandwichImage();
        }

        private Product getSandwich() {
            assert (this.getProduct(0).getMolecule() instanceof Molecule.Sandwich);
            return this.getProduct(0);
        }

        private void updateSandwichImage() {
            this.getSandwich().setImage(SandwichImageFactory.createImage(this));
        }
    }
}

