/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.reactantsproductsandleftovers.module.realreaction;

import edu.colorado.phet.common.phetcommon.model.Resettable;
import edu.colorado.phet.common.phetcommon.view.ResetAllButton;
import edu.colorado.phet.common.piccolophet.util.PNodeLayoutUtils;
import edu.colorado.phet.reactantsproductsandleftovers.RPALConstants;
import edu.colorado.phet.reactantsproductsandleftovers.module.realreaction.ReactionChoiceNode;
import edu.colorado.phet.reactantsproductsandleftovers.module.realreaction.RealReactionModel;
import edu.colorado.phet.reactantsproductsandleftovers.view.RPALCanvas;
import edu.colorado.phet.reactantsproductsandleftovers.view.RightArrowNode;
import edu.colorado.phet.reactantsproductsandleftovers.view.realreaction.RealReactionAfterNode;
import edu.colorado.phet.reactantsproductsandleftovers.view.realreaction.RealReactionBeforeNode;
import edu.colorado.phet.reactantsproductsandleftovers.view.realreaction.RealReactionEquationNode;
import edu.umd.cs.piccolo.util.PDimension;
import edu.umd.cs.piccolox.pswing.PSwing;
import java.awt.Component;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class RealReactionCanvas
extends RPALCanvas {
    private static final PDimension BOX_SIZE = RPALConstants.BEFORE_AFTER_BOX_SIZE;
    private final RealReactionModel model;
    private final ReactionChoiceNode reactionChoiceNode;
    private final RightArrowNode arrowNode;
    private final PSwing resetAllButtonWrapper;
    private RealReactionEquationNode equationNode;
    private RealReactionBeforeNode beforeNode;
    private RealReactionAfterNode afterNode;

    public RealReactionCanvas(RealReactionModel realReactionModel, Resettable resettable) {
        this.model = realReactionModel;
        this.reactionChoiceNode = new ReactionChoiceNode(realReactionModel);
        this.reactionChoiceNode.scale(1.25);
        this.addChild(this.reactionChoiceNode);
        this.arrowNode = new RightArrowNode();
        this.addChild(this.arrowNode);
        ResetAllButton resetAllButton = new ResetAllButton(resettable, (Component)this);
        this.resetAllButtonWrapper = new PSwing(resetAllButton);
        this.resetAllButtonWrapper.scale(1.25);
        this.addChild(this.resetAllButtonWrapper);
        realReactionModel.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                RealReactionCanvas.this.updateDynamicNodes();
            }
        });
        this.updateDynamicNodes();
    }

    private void updateDynamicNodes() {
        if (this.equationNode != null) {
            this.removeChild(this.equationNode);
            this.equationNode.cleanup();
        }
        this.equationNode = new RealReactionEquationNode(this.model.getReaction());
        this.addChild(this.equationNode);
        if (this.beforeNode != null) {
            this.removeChild(this.beforeNode);
            this.beforeNode.cleanup();
        }
        this.beforeNode = new RealReactionBeforeNode(this.model, BOX_SIZE);
        this.addChild(this.beforeNode);
        if (this.afterNode != null) {
            this.removeChild(this.afterNode);
            this.afterNode.cleanup();
        }
        this.afterNode = new RealReactionAfterNode(this.model, BOX_SIZE);
        this.addChild(this.afterNode);
        this.updateNodesLayout();
    }

    private void updateNodesLayout() {
        double d = 0.0;
        double d2 = 0.0;
        this.reactionChoiceNode.setOffset(d, d2);
        d = this.reactionChoiceNode.getFullBoundsReference().getWidth() + 30.0;
        d2 = this.reactionChoiceNode.getFullBoundsReference().getCenterY() - this.equationNode.getFullBoundsReference().getHeight() / 2.0;
        this.equationNode.setOffset(d, d2);
        d = this.reactionChoiceNode.getFullBoundsReference().getMinX();
        d2 = this.reactionChoiceNode.getFullBoundsReference().getMaxY() - PNodeLayoutUtils.getOriginYOffset(this.beforeNode) + 30.0;
        this.beforeNode.setOffset(d, d2);
        d = this.beforeNode.getFullBoundsReference().getMaxX() + 20.0;
        d2 = this.beforeNode.getYOffset() + BOX_SIZE.getHeight() / 2.0;
        this.arrowNode.setOffset(d, d2);
        d = this.arrowNode.getFullBoundsReference().getMaxX() + 20.0;
        d2 = this.beforeNode.getYOffset();
        this.afterNode.setOffset(d, d2);
        d = this.arrowNode.getFullBoundsReference().getMaxX() - this.resetAllButtonWrapper.getFullBoundsReference().getWidth();
        d2 = this.afterNode.getFullBoundsReference().getMaxY();
        this.resetAllButtonWrapper.setOffset(d, d2);
    }
}

