/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.reactantsproductsandleftovers.module.game;

import edu.colorado.phet.reactantsproductsandleftovers.model.ChemicalReaction;
import edu.colorado.phet.reactantsproductsandleftovers.model.OneProductReactions;
import edu.colorado.phet.reactantsproductsandleftovers.model.Product;
import edu.colorado.phet.reactantsproductsandleftovers.model.Reactant;
import edu.colorado.phet.reactantsproductsandleftovers.model.TwoProductReactions;
import edu.colorado.phet.reactantsproductsandleftovers.module.game.AbstractChallengeFactory;
import edu.colorado.phet.reactantsproductsandleftovers.module.game.GameChallenge;
import edu.colorado.phet.reactantsproductsandleftovers.module.game.GameModel;
import java.util.ArrayList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NumberOfVariablesChallengeFactory
extends AbstractChallengeFactory {
    private static final ArrayList<Class<? extends ChemicalReaction>> LEVEL2_LIST = new ArrayList();
    private static final ArrayList<Class<? extends ChemicalReaction>> LEVEL3_LIST;
    private static final ArrayList<Class<? extends ChemicalReaction>> LEVEL1_LIST;
    private static ArrayList<ArrayList<Class<? extends ChemicalReaction>>> REACTIONS;

    @Override
    public GameChallenge[] createChallenges(int n, int n2, int n3, GameChallenge.ChallengeVisibility challengeVisibility) {
        if (n2 < 1 || n2 > REACTIONS.size()) {
            throw new IllegalArgumentException("unsupported level: " + n2);
        }
        int n4 = (int)(Math.random() * (double)n);
        GameChallenge[] gameChallengeArray = new GameChallenge[n];
        ChemicalReaction chemicalReaction = null;
        for (int i = 0; i < gameChallengeArray.length; ++i) {
            GameChallenge.ChallengeType challengeType = n2 == 1 ? GameChallenge.ChallengeType.BEFORE : (n2 == 2 ? GameChallenge.ChallengeType.AFTER : GameChallenge.ChallengeType.AFTER);
            ChemicalReaction chemicalReaction2 = null;
            chemicalReaction2 = i == n4 ? this.createChallengeWithoutProducts(n2, n3, chemicalReaction) : this.createChallengeWithProducts(n2, n3, chemicalReaction);
            NumberOfVariablesChallengeFactory.fixQuantityRangeViolation(chemicalReaction2, n3);
            gameChallengeArray[i] = new GameChallenge(chemicalReaction2, challengeType, challengeVisibility);
            chemicalReaction = chemicalReaction2;
        }
        return gameChallengeArray;
    }

    private ChemicalReaction createChallengeWithProducts(int n, int n2, ChemicalReaction chemicalReaction) {
        ChemicalReaction chemicalReaction2 = this.getRandomReaction(n, chemicalReaction);
        for (Reactant reactant : chemicalReaction2.getReactants()) {
            reactant.setQuantity(NumberOfVariablesChallengeFactory.getRandomQuantity(reactant.getCoefficient(), n2));
        }
        return chemicalReaction2;
    }

    private ChemicalReaction createChallengeWithoutProducts(int n, int n2, ChemicalReaction chemicalReaction) {
        ChemicalReaction chemicalReaction2 = this.getRandomReactionThatCanHaveZeroProducts(n, chemicalReaction);
        for (Reactant reactant : chemicalReaction2.getReactants()) {
            reactant.setQuantity(NumberOfVariablesChallengeFactory.getRandomQuantity(Math.max(1, reactant.getCoefficient() - 1)));
        }
        return chemicalReaction2;
    }

    private ChemicalReaction getRandomReaction(int n, ChemicalReaction chemicalReaction) {
        int n2 = this.getRandomReactantIndex(n);
        Class<? extends ChemicalReaction> clazz = this.getReactionClass(n, n2);
        if (chemicalReaction != null && clazz.equals(chemicalReaction.getClass())) {
            n2 = this.getNextReactantIndex(n, n2);
            clazz = this.getReactionClass(n, n2);
        }
        return NumberOfVariablesChallengeFactory.instantiateReaction(clazz);
    }

    private ChemicalReaction getRandomReactionThatCanHaveZeroProducts(int n, ChemicalReaction chemicalReaction) {
        int n2 = this.getRandomReactantIndex(n);
        Class<? extends ChemicalReaction> clazz = this.getReactionClass(n, n2);
        ChemicalReaction chemicalReaction2 = NumberOfVariablesChallengeFactory.instantiateReaction(clazz);
        while (chemicalReaction != null && clazz.equals(chemicalReaction.getClass()) || this.reactantCoefficientsAllOne(chemicalReaction2)) {
            n2 = this.getNextReactantIndex(n, n2);
            clazz = this.getReactionClass(n, n2);
            chemicalReaction2 = NumberOfVariablesChallengeFactory.instantiateReaction(clazz);
        }
        return chemicalReaction2;
    }

    private boolean reactantCoefficientsAllOne(ChemicalReaction chemicalReaction) {
        boolean bl = true;
        for (Reactant reactant : chemicalReaction.getReactants()) {
            if (reactant.getCoefficient() == 1) continue;
            bl = false;
            break;
        }
        return bl;
    }

    private Class<? extends ChemicalReaction> getReactionClass(int n, int n2) {
        return this.getReactionList(n).get(n2);
    }

    private int getNumberOfReactions(int n) {
        return this.getReactionList(n).size();
    }

    private int getRandomReactantIndex(int n) {
        return (int)(Math.random() * (double)this.getNumberOfReactions(n));
    }

    private int getNextReactantIndex(int n, int n2) {
        int n3 = n2 + 1;
        if (n3 > this.getNumberOfReactions(n) - 1) {
            n3 = 0;
        }
        return n3;
    }

    private ArrayList<Class<? extends ChemicalReaction>> getReactionList(int n) {
        return REACTIONS.get(n - 1);
    }

    public static void main(String[] stringArray) {
        GameChallenge[] gameChallengeArray;
        int n;
        NumberOfVariablesChallengeFactory numberOfVariablesChallengeFactory = new NumberOfVariablesChallengeFactory();
        ArrayList<Class> arrayList = new ArrayList<Class>();
        for (n = 1; n <= REACTIONS.size(); ++n) {
            System.out.println();
            System.out.println("Level " + n + " --------------------------------------");
            for (int i = 0; i < numberOfVariablesChallengeFactory.getNumberOfReactions(n); ++i) {
                Class clazz = numberOfVariablesChallengeFactory.getReactionClass(n, i);
                gameChallengeArray = NumberOfVariablesChallengeFactory.instantiateReaction(clazz);
                System.out.println(gameChallengeArray.getEquationPlainText());
                if (arrayList.contains(clazz)) continue;
                arrayList.add(clazz);
            }
        }
        n = GameModel.getQuantityRange().getMax();
        System.out.println();
        System.out.println("LOOKING FOR COEFFICIENTS RANGE VIOLATIONS ...");
        System.out.println();
        block2: for (Class clazz : arrayList) {
            gameChallengeArray = NumberOfVariablesChallengeFactory.instantiateReaction(clazz);
            for (Reactant reactant : gameChallengeArray.getReactants()) {
                if (reactant.getCoefficient() >= 1 && reactant.getCoefficient() <= n) continue;
                System.out.println("ERROR: coefficient out of range : " + gameChallengeArray.getEquationPlainText());
                continue block2;
            }
        }
        System.out.println("LOOKING FOR QUANTITY RANGE VIOLATIONS THAT CANNOT BE FIXED ...");
        System.out.println();
        for (Class clazz : arrayList) {
            gameChallengeArray = NumberOfVariablesChallengeFactory.instantiateReaction(clazz);
            for (Reactant reactant : gameChallengeArray.getReactants()) {
                reactant.setQuantity(n);
            }
            NumberOfVariablesChallengeFactory.fixQuantityRangeViolation((ChemicalReaction)gameChallengeArray, n, true);
        }
        System.out.println();
        System.out.println("TESTING CHALLENGE GENERATION ...");
        System.out.println();
        for (int i = GameModel.LEVEL_RANGE.getMin(); i <= GameModel.LEVEL_RANGE.getMax(); ++i) {
            for (int j = 0; j < 100; ++j) {
                gameChallengeArray = numberOfVariablesChallengeFactory.createChallenges(GameModel.getChallengesPerGame(), i, n, GameChallenge.ChallengeVisibility.BOTH);
                int n2 = 0;
                for (GameChallenge gameChallenge : gameChallengeArray) {
                    boolean bl = false;
                    for (Reactant reactant : gameChallenge.getReaction().getReactants()) {
                        if (reactant.getQuantity() >= 1) continue;
                        bl = true;
                    }
                    if (bl) {
                        System.out.println("ERROR: challenge has zero reactants, level=" + i + " : " + gameChallenge.getReaction().toString());
                    }
                    int n3 = 0;
                    for (Product product : gameChallenge.getReaction().getProducts()) {
                        if (product.getQuantity() <= 0) continue;
                        ++n3;
                    }
                    if (n3 != 0) continue;
                    ++n2;
                }
                if (n2 == true) continue;
                System.out.println("ERROR: more than one challenge with zero products, level=" + i + " challenges=");
                for (int k = 0; k < gameChallengeArray.length; ++k) {
                    System.out.println(k + ": " + gameChallengeArray[k].getReaction().toString());
                }
            }
        }
        System.out.println("Done.");
    }

    static {
        LEVEL2_LIST.add(OneProductReactions.WaterReaction.class);
        LEVEL2_LIST.add(OneProductReactions.Reaction_H2_F2__2HF.class);
        LEVEL2_LIST.add(OneProductReactions.Reaction_H2_Cl2__2HCl.class);
        LEVEL2_LIST.add(OneProductReactions.Reaction_CO_2H2__CH3OH.class);
        LEVEL2_LIST.add(OneProductReactions.Reaction_CH2O_H2__CH3OH.class);
        LEVEL2_LIST.add(OneProductReactions.Reaction_C2H4_H2__C2H6.class);
        LEVEL2_LIST.add(OneProductReactions.Reaction_C2H2_2H2__C2H6.class);
        LEVEL2_LIST.add(OneProductReactions.Reaction_C_O2__CO2.class);
        LEVEL2_LIST.add(OneProductReactions.Reaction_2C_O2__2CO.class);
        LEVEL2_LIST.add(OneProductReactions.Reaction_2CO_O2__2CO2.class);
        LEVEL2_LIST.add(OneProductReactions.Reaction_C_CO2__2CO.class);
        LEVEL2_LIST.add(OneProductReactions.Reaction_C_2S__CS2.class);
        LEVEL2_LIST.add(OneProductReactions.AmmoniaReaction.class);
        LEVEL2_LIST.add(OneProductReactions.Reaction_N2_O2__2NO.class);
        LEVEL2_LIST.add(OneProductReactions.Reaction_2NO_O2__2NO2.class);
        LEVEL2_LIST.add(OneProductReactions.Reaction_2N2_O2__2NO2.class);
        LEVEL2_LIST.add(OneProductReactions.Reaction_P4_6H2__4PH3.class);
        LEVEL2_LIST.add(OneProductReactions.Reaction_P4_6F2__4PF3.class);
        LEVEL2_LIST.add(OneProductReactions.Reaction_P4_6Cl2__4PCl3.class);
        LEVEL2_LIST.add(OneProductReactions.Reaction_P4_10Cl2__4PCl5.class);
        LEVEL2_LIST.add(OneProductReactions.Reaction_PCl3_Cl2__PCl5.class);
        LEVEL2_LIST.add(OneProductReactions.Reaction_2SO2_O2__2SO3.class);
        LEVEL3_LIST = new ArrayList();
        LEVEL3_LIST.add(TwoProductReactions.Reaction_2C_2H2O__CH4_CO2.class);
        LEVEL3_LIST.add(TwoProductReactions.Reaction_CH4_H2O__3H2_CO.class);
        LEVEL3_LIST.add(TwoProductReactions.MethaneReaction.class);
        LEVEL3_LIST.add(TwoProductReactions.Reaction_2C2H6_7O2__4CO2_6H2O.class);
        LEVEL3_LIST.add(TwoProductReactions.Reaction_C2H4_3O2__2CO2_2H2O.class);
        LEVEL3_LIST.add(TwoProductReactions.Reaction_2C2H2_5O2__4CO2_2H2O.class);
        LEVEL3_LIST.add(TwoProductReactions.Reaction_C2H5OH_3O2__2CO2_3H2O.class);
        LEVEL3_LIST.add(TwoProductReactions.Reaction_C2H6_Cl2__C2H5Cl_HCl.class);
        LEVEL3_LIST.add(TwoProductReactions.Reaction_CH4_4S__CS2_2H2S.class);
        LEVEL3_LIST.add(TwoProductReactions.Reaction_CS2_3O2__CO2_2SO2.class);
        LEVEL3_LIST.add(TwoProductReactions.Reaction_4NH3_3O2__2N2_6H2O.class);
        LEVEL3_LIST.add(TwoProductReactions.Reaction_4NH3_5O2__4NO_6H2O.class);
        LEVEL3_LIST.add(TwoProductReactions.Reaction_4NH3_7O2__4NO2_6H2O.class);
        LEVEL3_LIST.add(TwoProductReactions.Reaction_4NH3_6NO__5N2_6H2O.class);
        LEVEL3_LIST.add(TwoProductReactions.Reaction_SO2_2H2__S_2H2O.class);
        LEVEL3_LIST.add(TwoProductReactions.Reaction_SO2_3H2__H2S_2H2O.class);
        LEVEL3_LIST.add(TwoProductReactions.Reaction_2F2_H2O__OF2_2HF.class);
        LEVEL3_LIST.add(TwoProductReactions.Reaction_OF2_H2O__O2_2HF.class);
        LEVEL1_LIST = new ArrayList();
        LEVEL1_LIST.addAll(LEVEL2_LIST);
        LEVEL1_LIST.addAll(LEVEL3_LIST);
        REACTIONS = new ArrayList();
        REACTIONS.add(LEVEL1_LIST);
        REACTIONS.add(LEVEL2_LIST);
        REACTIONS.add(LEVEL3_LIST);
    }
}

