/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.reactantsproductsandleftovers.module.game;

import edu.colorado.phet.reactantsproductsandleftovers.model.ChemicalReaction;
import edu.colorado.phet.reactantsproductsandleftovers.module.game.GameGuess;

public class GameChallenge {
    private final ChemicalReaction reaction;
    private final ChallengeType challengeType;
    private final ChallengeVisibility challengeVisibility;
    private final GameGuess guess;

    public GameChallenge(ChemicalReaction chemicalReaction, ChallengeType challengeType, ChallengeVisibility challengeVisibility) {
        this.reaction = chemicalReaction;
        this.challengeType = challengeType;
        this.challengeVisibility = challengeVisibility;
        this.guess = new GameGuess(chemicalReaction, challengeType);
    }

    public ChemicalReaction getReaction() {
        return this.reaction;
    }

    public ChallengeType getChallengeType() {
        return this.challengeType;
    }

    public boolean isMoleculesVisible() {
        return this.challengeVisibility != ChallengeVisibility.NUMBERS;
    }

    public boolean isNumbersVisible() {
        return this.challengeVisibility != ChallengeVisibility.MOLECULES;
    }

    public GameGuess getGuess() {
        return this.guess;
    }

    public boolean isCorrect() {
        int n;
        for (n = 0; n < this.reaction.getNumberOfReactants(); ++n) {
            if (this.guess.getReactant(n).equals(this.reaction.getReactant(n))) continue;
            return false;
        }
        for (n = 0; n < this.reaction.getNumberOfProducts(); ++n) {
            if (this.guess.getProduct(n).equals(this.reaction.getProduct(n))) continue;
            return false;
        }
        return true;
    }

    public String toString() {
        return this.reaction.getEquationHTML() + " : " + this.reaction.getQuantitiesString() + " : " + this.getChallengeTypeString();
    }

    private String getChallengeTypeString() {
        return this.challengeType == ChallengeType.BEFORE ? "Before" : "After";
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class ChallengeType
    extends Enum<ChallengeType> {
        public static final /* enum */ ChallengeType BEFORE = new ChallengeType();
        public static final /* enum */ ChallengeType AFTER = new ChallengeType();
        private static final /* synthetic */ ChallengeType[] $VALUES;

        public static ChallengeType[] values() {
            return (ChallengeType[])$VALUES.clone();
        }

        static {
            $VALUES = new ChallengeType[]{BEFORE, AFTER};
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class ChallengeVisibility
    extends Enum<ChallengeVisibility> {
        public static final /* enum */ ChallengeVisibility MOLECULES = new ChallengeVisibility();
        public static final /* enum */ ChallengeVisibility NUMBERS = new ChallengeVisibility();
        public static final /* enum */ ChallengeVisibility BOTH = new ChallengeVisibility();
        private static final /* synthetic */ ChallengeVisibility[] $VALUES;

        public static ChallengeVisibility[] values() {
            return (ChallengeVisibility[])$VALUES.clone();
        }

        static {
            $VALUES = new ChallengeVisibility[]{MOLECULES, NUMBERS, BOTH};
        }
    }
}

