/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.reactantsproductsandleftovers.module.game;

import edu.colorado.phet.reactantsproductsandleftovers.model.ChemicalReaction;
import edu.colorado.phet.reactantsproductsandleftovers.model.Reactant;
import edu.colorado.phet.reactantsproductsandleftovers.module.game.GameModel;
import edu.colorado.phet.reactantsproductsandleftovers.module.game.IChallengeFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractChallengeFactory
implements IChallengeFactory {
    protected static int getRandomQuantity(int n) {
        return AbstractChallengeFactory.getRandomQuantity(1, n);
    }

    protected static int getRandomQuantity(int n, int n2) {
        if (n <= 0) {
            throw new IllegalArgumentException("min must be > 0: " + n);
        }
        if (n > n2) {
            throw new IllegalArgumentException("min must be <= max");
        }
        return n + (int)(Math.random() * (double)(n2 - n + 1));
    }

    protected static ChemicalReaction instantiateReaction(Class<? extends ChemicalReaction> clazz) {
        ChemicalReaction chemicalReaction = null;
        try {
            chemicalReaction = clazz.newInstance();
        }
        catch (InstantiationException instantiationException) {
            instantiationException.printStackTrace();
        }
        catch (IllegalAccessException illegalAccessException) {
            illegalAccessException.printStackTrace();
        }
        return chemicalReaction;
    }

    protected static void fixQuantityRangeViolation(ChemicalReaction chemicalReaction, int n) {
        AbstractChallengeFactory.fixQuantityRangeViolation(chemicalReaction, n, false);
    }

    protected static void fixQuantityRangeViolation(ChemicalReaction chemicalReaction, int n, boolean bl) {
        if (AbstractChallengeFactory.hasQuantityRangeViolation(chemicalReaction)) {
            if (bl) {
                System.out.print("AbstractGameStrategy.fixQuantityRangeViolation");
                System.out.print(" reaction: " + chemicalReaction.getEquationPlainText());
                System.out.print(" violation: " + chemicalReaction.getQuantitiesString());
            }
            for (Reactant reactant : chemicalReaction.getReactants()) {
                if (reactant.getQuantity() <= n) continue;
                reactant.setQuantity(n);
            }
            int n2 = 0;
            int n3 = 0;
            while (AbstractChallengeFactory.hasQuantityRangeViolation(chemicalReaction)) {
                Reactant reactant = chemicalReaction.getReactant(n2);
                int n4 = reactant.getQuantity();
                if (n4 > 1) {
                    reactant.setQuantity(n4 - 1);
                    n3 = 1;
                }
                if (++n2 <= chemicalReaction.getNumberOfReactants() - 1) continue;
                n2 = 0;
                if (n3 != 0) continue;
                break;
            }
            if (AbstractChallengeFactory.hasQuantityRangeViolation(chemicalReaction)) {
                throw new IllegalStateException("range violation can't be fixed: " + chemicalReaction.getEquationHTML() + " : " + chemicalReaction.getQuantitiesString());
            }
            if (bl) {
                System.out.println(" fixed: " + chemicalReaction.getQuantitiesString());
            }
        }
    }

    protected static boolean hasQuantityRangeViolation(ChemicalReaction chemicalReaction) {
        int n;
        int n2 = GameModel.getQuantityRange().getMax();
        boolean bl = false;
        for (n = 0; !bl && n < chemicalReaction.getNumberOfReactants(); ++n) {
            if (chemicalReaction.getReactant(n).getQuantity() <= n2 && chemicalReaction.getReactant(n).getLeftovers() <= n2) continue;
            bl = true;
        }
        for (n = 0; !bl && n < chemicalReaction.getNumberOfProducts(); ++n) {
            if (chemicalReaction.getProduct(n).getQuantity() <= n2) continue;
            bl = true;
        }
        return bl;
    }
}

