/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.reactantsproductsandleftovers.model;

import edu.colorado.phet.reactantsproductsandleftovers.model.Molecule;
import java.awt.Image;
import java.util.EventListener;
import javax.swing.event.EventListenerList;

public abstract class Substance {
    private final Molecule molecule;
    private int coefficient;
    private int quantity;
    private final EventListenerList listeners;

    public Substance(int n, Molecule molecule, int n2) {
        this.molecule = molecule;
        this.coefficient = n;
        this.quantity = n2;
        this.listeners = new EventListenerList();
    }

    public boolean equals(Object object) {
        if (!(object instanceof Substance)) {
            return false;
        }
        Substance substance = (Substance)object;
        if (!this.getName().equals(substance.getName())) {
            return false;
        }
        if (this.getCoefficient() != substance.getCoefficient()) {
            return false;
        }
        return this.getQuantity() == substance.getQuantity();
    }

    public Molecule getMolecule() {
        return this.molecule;
    }

    public String getName() {
        return this.molecule.getSymbol();
    }

    public String getPlainTextName() {
        return this.getName().replaceAll("<sub>", "").replaceAll("</sub>", "");
    }

    public Image getImage() {
        return this.molecule.getImage();
    }

    public void setImage(Image image) {
        if (image != this.getImage()) {
            this.molecule.setImage(image);
            this.fireImageChanged();
        }
    }

    public void setCoefficient(int n) {
        if (n < 0) {
            throw new IllegalArgumentException("coefficient must be >= 0: " + n);
        }
        if (n != this.coefficient) {
            this.coefficient = n;
            this.fireCoefficientChanged();
        }
    }

    public int getCoefficient() {
        return this.coefficient;
    }

    public void setQuantity(int n) {
        if (n < 0) {
            throw new IllegalArgumentException("quantity must be >= 0: " + n);
        }
        if (n != this.quantity) {
            this.quantity = n;
            this.fireQuantityChanged();
        }
    }

    public int getQuantity() {
        return this.quantity;
    }

    public void addSubstanceChangeListener(SubstanceChangeListener substanceChangeListener) {
        this.listeners.add(SubstanceChangeListener.class, substanceChangeListener);
    }

    public void removeSubstanceChangeListener(SubstanceChangeListener substanceChangeListener) {
        this.listeners.remove(SubstanceChangeListener.class, substanceChangeListener);
    }

    private void fireCoefficientChanged() {
        for (SubstanceChangeListener substanceChangeListener : (SubstanceChangeListener[])this.listeners.getListeners(SubstanceChangeListener.class)) {
            substanceChangeListener.coefficientChanged();
        }
    }

    private void fireQuantityChanged() {
        for (SubstanceChangeListener substanceChangeListener : (SubstanceChangeListener[])this.listeners.getListeners(SubstanceChangeListener.class)) {
            substanceChangeListener.quantityChanged();
        }
    }

    private void fireImageChanged() {
        for (SubstanceChangeListener substanceChangeListener : (SubstanceChangeListener[])this.listeners.getListeners(SubstanceChangeListener.class)) {
            substanceChangeListener.imageChanged();
        }
    }

    public static class SubstanceChangeAdapter
    implements SubstanceChangeListener {
        public void coefficientChanged() {
        }

        public void quantityChanged() {
        }

        public void imageChanged() {
        }
    }

    public static interface SubstanceChangeListener
    extends EventListener {
        public void coefficientChanged();

        public void quantityChanged();

        public void imageChanged();
    }
}

