/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.reactantsproductsandleftovers.model;

import edu.colorado.phet.reactantsproductsandleftovers.model.Molecule;
import edu.colorado.phet.reactantsproductsandleftovers.model.Substance;
import javax.swing.event.EventListenerList;

public final class Reactant
extends Substance {
    private int leftovers = 0;
    private final EventListenerList listeners = new EventListenerList();

    public Reactant(int n, Molecule molecule) {
        this(n, molecule, 0);
    }

    public Reactant(int n, Molecule molecule, int n2) {
        super(n, molecule, n2);
    }

    public Reactant(Reactant reactant) {
        this(reactant.getCoefficient(), reactant.getMolecule(), reactant.getQuantity());
        this.setLeftovers(reactant.getLeftovers());
    }

    public static Reactant newInstance(Reactant reactant) {
        return new Reactant(reactant);
    }

    public boolean equals(Object object) {
        if (!(object instanceof Reactant)) {
            return false;
        }
        Reactant reactant = (Reactant)object;
        if (!super.equals(reactant)) {
            return false;
        }
        return this.getLeftovers() == reactant.getLeftovers();
    }

    public void setLeftovers(int n) {
        if (n < 0) {
            throw new IllegalArgumentException("leftover must be >= 0: " + n);
        }
        if (n != this.leftovers) {
            this.leftovers = n;
            this.fireLeftoverChanged();
        }
    }

    public int getLeftovers() {
        return this.leftovers;
    }

    public void addReactantChangeListener(ReactantChangeListener reactantChangeListener) {
        super.addSubstanceChangeListener(reactantChangeListener);
        this.listeners.add(ReactantChangeListener.class, reactantChangeListener);
    }

    public void removeReactantChangeListener(ReactantChangeListener reactantChangeListener) {
        super.removeSubstanceChangeListener(reactantChangeListener);
        this.listeners.remove(ReactantChangeListener.class, reactantChangeListener);
    }

    private void fireLeftoverChanged() {
        for (ReactantChangeListener reactantChangeListener : (ReactantChangeListener[])this.listeners.getListeners(ReactantChangeListener.class)) {
            reactantChangeListener.leftoversChanged();
        }
    }

    public static class ReactantChangeAdapter
    extends Substance.SubstanceChangeAdapter
    implements ReactantChangeListener {
        public void leftoversChanged() {
        }
    }

    public static interface ReactantChangeListener
    extends Substance.SubstanceChangeListener {
        public void leftoversChanged();
    }
}

