/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.reactantsproductsandleftovers.controls;

import edu.colorado.phet.common.phetcommon.simsharing.messages.IUserComponent;
import edu.colorado.phet.common.phetcommon.util.IntegerRange;
import edu.colorado.phet.reactantsproductsandleftovers.controls.ValueNode;
import edu.colorado.phet.reactantsproductsandleftovers.model.Reactant;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class LeftoversValueNode
extends ValueNode {
    private Reactant reactant;
    private final Reactant.ReactantChangeListener reactantChangeListener;

    public LeftoversValueNode(IUserComponent iUserComponent, Reactant reactant, IntegerRange integerRange, double d, boolean bl) {
        super(iUserComponent, integerRange, reactant.getLeftovers(), reactant.getImage(), d, reactant.getName(), bl, false);
        this.reactant = reactant;
        this.reactantChangeListener = new Reactant.ReactantChangeAdapter(){

            public void leftoversChanged() {
                LeftoversValueNode.this.updateLeftovers();
            }

            public void imageChanged() {
                LeftoversValueNode.this.updateImage();
            }
        };
        reactant.addReactantChangeListener(this.reactantChangeListener);
        this.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                LeftoversValueNode.this.updateModel();
            }
        });
    }

    public void setReactant(Reactant reactant) {
        if (reactant != this.reactant) {
            this.reactant.removeSubstanceChangeListener(this.reactantChangeListener);
            this.reactant = reactant;
            this.updateLeftovers();
            this.updateImage();
            this.reactant.addSubstanceChangeListener(this.reactantChangeListener);
        }
    }

    public void cleanup() {
        this.reactant.removeReactantChangeListener(this.reactantChangeListener);
    }

    private void updateLeftovers() {
        this.setValue(this.reactant.getLeftovers());
    }

    private void updateImage() {
        this.setImage(this.reactant.getImage());
    }

    private void updateModel() {
        this.reactant.setLeftovers(this.getValue());
    }
}

