/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.reactantsproductsandleftovers.controls;

import edu.colorado.phet.reactantsproductsandleftovers.RPALColors;
import edu.umd.cs.piccolo.PNode;
import edu.umd.cs.piccolo.nodes.PPath;
import edu.umd.cs.piccolo.util.PDimension;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Stroke;
import java.awt.geom.GeneralPath;
import java.awt.geom.Rectangle2D;

public class HistogramBarNode
extends PNode {
    private static final Stroke STROKE = new BasicStroke(1.0f);
    private static final Color STROKE_COLOR = Color.BLACK;
    private static final Color BACKGROUND_COLOR = Color.WHITE;
    private static final Color FILL_COLOR = RPALColors.HISTOGRAM_BAR_COLOR;
    private final double min;
    private final double max;
    private final PDimension size;
    private final FillNode fillNode;

    public HistogramBarNode(double d, double d2, double d3, PDimension pDimension) {
        this.setPickable(false);
        this.setChildrenPickable(false);
        this.min = d2;
        this.max = d3;
        this.size = new PDimension(pDimension);
        BackgroundNode backgroundNode = new BackgroundNode(pDimension);
        this.fillNode = new FillNode(pDimension);
        StrokeNode strokeNode = new StrokeNode(pDimension);
        this.addChild(backgroundNode);
        this.addChild(this.fillNode);
        this.addChild(strokeNode);
        this.setValue(d);
    }

    public void setValue(double d) {
        if (!(d >= this.min) || !(d <= this.max)) {
            throw new IllegalArgumentException("value is out of range: " + d);
        }
        double d2 = this.size.getHeight() * (d - this.min) / this.max;
        this.fillNode.setFillHeight(d2);
    }

    private static class BackgroundNode
    extends PNode {
        public BackgroundNode(PDimension pDimension) {
            PPath pPath = new PPath();
            pPath.setPathTo(new Rectangle2D.Double(0.0, 0.0, pDimension.getWidth(), pDimension.getHeight()));
            pPath.setPaint(BACKGROUND_COLOR);
            pPath.setStroke(null);
            this.addChild(pPath);
        }
    }

    private static class FillNode
    extends PPath {
        private final PDimension maxSize;
        private final GeneralPath path;

        public FillNode(PDimension pDimension) {
            this.maxSize = pDimension;
            this.path = new GeneralPath();
            this.setPaint(FILL_COLOR);
            this.setStroke(null);
        }

        public void setFillHeight(double d) {
            this.path.reset();
            this.path.moveTo(0.0f, (float)this.maxSize.getHeight());
            this.path.lineTo(0.0f, (float)(this.maxSize.getHeight() - d));
            this.path.lineTo((float)this.maxSize.getWidth(), (float)(this.maxSize.getHeight() - d));
            this.path.lineTo((float)this.maxSize.getWidth(), (float)this.maxSize.getHeight());
            this.path.closePath();
            this.setPathTo(this.path);
        }
    }

    private static class StrokeNode
    extends PPath {
        public StrokeNode(PDimension pDimension) {
            super(new Rectangle2D.Double(0.0, 0.0, pDimension.getWidth(), pDimension.getHeight()));
            this.setStroke(STROKE);
            this.setStrokePaint(STROKE_COLOR);
            this.setPaint(null);
        }
    }
}

