/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.common.phetcommon.view.controls;

import edu.colorado.phet.common.phetcommon.resources.PhetCommonResources;
import edu.colorado.phet.common.phetcommon.simsharing.SimSharingManager;
import edu.colorado.phet.common.phetcommon.simsharing.components.SimSharingJSpinner;
import edu.colorado.phet.common.phetcommon.simsharing.messages.IParameterKey;
import edu.colorado.phet.common.phetcommon.simsharing.messages.IUserComponent;
import edu.colorado.phet.common.phetcommon.simsharing.messages.ParameterKeys;
import edu.colorado.phet.common.phetcommon.simsharing.messages.ParameterSet;
import edu.colorado.phet.common.phetcommon.simsharing.messages.SystemActions;
import edu.colorado.phet.common.phetcommon.simsharing.messages.SystemComponentTypes;
import edu.colorado.phet.common.phetcommon.simsharing.messages.SystemComponents;
import edu.colorado.phet.common.phetcommon.util.IntegerRange;
import edu.colorado.phet.common.phetcommon.view.util.PhetOptionPane;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.text.MessageFormat;
import java.text.ParseException;
import javax.swing.JFormattedTextField;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;
import javax.swing.SwingUtilities;
import javax.swing.Timer;

public class IntegerSpinner
extends SimSharingJSpinner {
    private final IntegerRange range;
    private final JFormattedTextField textField;

    public IntegerSpinner(IUserComponent iUserComponent, IntegerRange integerRange) {
        super(iUserComponent);
        this.range = integerRange;
        this.setModel(new SpinnerNumberModel(integerRange.getDefault(), integerRange.getMin(), integerRange.getMax(), 1));
        JSpinner.NumberEditor numberEditor = new JSpinner.NumberEditor(this);
        this.setEditor(numberEditor);
        this.textField = numberEditor.getTextField();
        this.textField.setColumns(String.valueOf(integerRange.getMax()).length());
        this.textField.addKeyListener(new KeyAdapter(){

            public void keyPressed(KeyEvent keyEvent) {
                if (keyEvent.getKeyCode() == 10) {
                    IntegerSpinner.this.commitEdit();
                }
            }
        });
        this.textField.addFocusListener(new FocusAdapter(){

            public void focusLost(FocusEvent focusEvent) {
                IntegerSpinner.this.commitEdit();
            }

            public void focusGained(FocusEvent focusEvent) {
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        IntegerSpinner.this.textField.selectAll();
                    }
                });
            }
        });
    }

    public void setIntValue(int n) {
        this.setValue(new Integer(n));
    }

    public int getIntValue() {
        return (Integer)this.getValue();
    }

    public void commitEdit() {
        try {
            super.commitEdit();
        }
        catch (ParseException parseException) {
            this.handleInvalidValueDelayed(this.textField.getText());
        }
    }

    private void handleInvalidValueDelayed(final String string) {
        Timer timer = new Timer(500, new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                IntegerSpinner.this.handleInvalidValue(string);
            }
        });
        timer.setRepeats(false);
        timer.start();
    }

    private void handleInvalidValue(String string) {
        this.textField.setValue(this.getValue());
        Toolkit.getDefaultToolkit().beep();
        this.showInvalidValueDialog(string);
    }

    private void showInvalidValueDialog(String string) {
        Object[] objectArray = new Object[]{new Integer(this.range.getMin()), new Integer(this.range.getMax())};
        String string2 = MessageFormat.format(PhetCommonResources.getString("message.valueOutOfRange"), objectArray);
        SimSharingManager.sendSystemMessage(SystemComponents.invalidValueDialog, SystemComponentTypes.window, SystemActions.windowOpened, ParameterSet.parameterSet((IParameterKey)ParameterKeys.value, string));
        PhetOptionPane.showErrorDialog(this, string2);
    }
}

