/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.piccolo.util;

import edu.umd.cs.piccolo.util.PDimension;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.io.Serializable;

public class PBounds
extends Rectangle2D.Double
implements Serializable {
    private boolean isEmpty = true;

    public PBounds() {
    }

    public PBounds(PBounds pBounds) {
        this(pBounds.x, pBounds.y, pBounds.width, pBounds.height);
        this.isEmpty = pBounds.isEmpty();
    }

    public PBounds(Rectangle2D rectangle2D) {
        this(rectangle2D.getX(), rectangle2D.getY(), rectangle2D.getWidth(), rectangle2D.getHeight());
        this.isEmpty = rectangle2D.isEmpty();
    }

    public PBounds(Point2D point2D, double d, double d2) {
        this(point2D.getX(), point2D.getY(), 0.0, 0.0);
        this.inset(d, d2);
    }

    public PBounds(double d, double d2, double d3, double d4) {
        super(d, d2, d3, d4);
        this.isEmpty = false;
    }

    public Object clone() {
        return new PBounds(this);
    }

    public boolean isEmpty() {
        return this.isEmpty;
    }

    public PBounds reset() {
        this.isEmpty = true;
        return this;
    }

    public PBounds resetToZero() {
        this.x = 0.0;
        this.y = 0.0;
        this.width = 0.0;
        this.height = 0.0;
        this.isEmpty = true;
        return this;
    }

    public void setRect(Rectangle2D rectangle2D) {
        super.setRect(rectangle2D);
        this.isEmpty = false;
    }

    public void setRect(PBounds pBounds) {
        this.isEmpty = pBounds.isEmpty;
        this.x = pBounds.x;
        this.y = pBounds.y;
        this.width = pBounds.width;
        this.height = pBounds.height;
    }

    public void setRect(double d, double d2, double d3, double d4) {
        this.x = d;
        this.y = d2;
        this.width = d3;
        this.height = d4;
        this.isEmpty = false;
    }

    public void add(double d, double d2) {
        if (this.isEmpty) {
            this.setRect(d, d2, 0.0, 0.0);
            this.isEmpty = false;
        } else {
            super.add(d, d2);
        }
    }

    public void add(Rectangle2D rectangle2D) {
        if (this.isEmpty) {
            this.setRect(rectangle2D);
        } else {
            super.add(rectangle2D);
        }
    }

    public void add(PBounds pBounds) {
        if (pBounds.isEmpty) {
            return;
        }
        if (this.isEmpty) {
            this.x = pBounds.x;
            this.y = pBounds.y;
            this.width = pBounds.width;
            this.height = pBounds.height;
            this.isEmpty = false;
        } else {
            double d = Math.min(this.x, pBounds.x);
            double d2 = Math.min(this.y, pBounds.y);
            double d3 = Math.max(this.x + this.width, pBounds.x + pBounds.width);
            double d4 = Math.max(this.y + this.height, pBounds.y + pBounds.height);
            this.x = d;
            this.y = d2;
            this.width = d3 - d;
            this.height = d4 - d2;
            this.isEmpty = false;
        }
    }

    public Point2D getCenter2D() {
        return new Point2D.Double(this.getCenterX(), this.getCenterY());
    }

    public void expandNearestIntegerDimensions() {
        this.x = Math.floor(this.x);
        this.y = Math.floor(this.y);
        this.width = Math.ceil(this.width);
        this.height = Math.ceil(this.height);
    }

    public PBounds inset(double d, double d2) {
        this.setRect(this.x + d, this.y + d2, this.width - d * 2.0, this.height - d2 * 2.0);
        return this;
    }

    public PDimension deltaRequiredToContain(Rectangle2D rectangle2D) {
        double d;
        double d2;
        PDimension pDimension = new PDimension();
        if (this.contains(rectangle2D)) {
            return pDimension;
        }
        double d3 = rectangle2D.getMaxX();
        double d4 = rectangle2D.getMinX();
        double d5 = rectangle2D.getMaxY();
        double d6 = rectangle2D.getMinY();
        double d7 = this.getMaxX();
        double d8 = this.getMinX();
        double d9 = this.getMaxY();
        double d10 = this.getMinY();
        if (d3 > d7 ^ d4 < d8) {
            d2 = d3 - d7;
            d = d4 - d8;
            pDimension.width = Math.abs(d2) < Math.abs(d) ? d2 : d;
        }
        if (d5 > d9 ^ d6 < d10) {
            d2 = d5 - d9;
            d = d6 - d10;
            pDimension.height = Math.abs(d2) < Math.abs(d) ? d2 : d;
        }
        return pDimension;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.getClass().getName().replaceAll(".*\\.", ""));
        stringBuffer.append('[');
        if (this.isEmpty) {
            stringBuffer.append("EMPTY");
        } else {
            stringBuffer.append("x=");
            stringBuffer.append(this.x);
            stringBuffer.append(",y=");
            stringBuffer.append(this.y);
            stringBuffer.append(",width=");
            stringBuffer.append(this.width);
            stringBuffer.append(",height=");
            stringBuffer.append(this.height);
        }
        stringBuffer.append(']');
        return stringBuffer.toString();
    }
}

