/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.quantumwaveinterference.view.piccolo.detectorscreen;

import edu.colorado.phet.common.phetcommon.view.util.ImageLoader;
import edu.colorado.phet.common.piccolophet.event.CursorHandler;
import edu.colorado.phet.quantumwaveinterference.view.QWIPanel;
import edu.umd.cs.piccolo.PNode;
import edu.umd.cs.piccolo.event.PBasicInputEventHandler;
import edu.umd.cs.piccolo.event.PInputEvent;
import edu.umd.cs.piccolo.nodes.PImage;
import edu.umd.cs.piccolo.nodes.PPath;
import edu.umd.cs.piccolox.pswing.PSwing;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.io.IOException;
import javax.swing.ImageIcon;
import javax.swing.JButton;

public class SavedScreenGraphic
extends PNode {
    private QWIPanel QWIPanel;
    private BufferedImage image;
    private Insets m = new Insets(2, 2, 2, 2);

    public SavedScreenGraphic(final QWIPanel qWIPanel, BufferedImage bufferedImage) {
        this.QWIPanel = qWIPanel;
        this.image = bufferedImage;
        PPath pPath = new PPath(new Rectangle2D.Double(0.0, 0.0, bufferedImage.getWidth(), bufferedImage.getHeight()));
        pPath.setStroke(new BasicStroke(2.0f));
        pPath.setStrokePaint(Color.lightGray);
        PImage pImage = new PImage(bufferedImage);
        this.addChild(pImage);
        this.addChild(pPath);
        this.addInputEventListener(new PBasicInputEventHandler(){

            public void mouseDragged(PInputEvent pInputEvent) {
                super.mouseDragged(pInputEvent);
                SavedScreenGraphic.this.translate(pInputEvent.getDelta().width, pInputEvent.getDelta().height);
            }
        });
        this.addInputEventListener(new CursorHandler(12));
        try {
            BufferedImage bufferedImage2 = ImageLoader.loadBufferedImage("quantum-wave-interference/images/x-14.jpg");
            JButton jButton = new JButton(new ImageIcon(bufferedImage2));
            jButton.setMargin(this.m);
            PSwing pSwing = new PSwing(jButton);
            this.addChild(pSwing);
            pSwing.setOffset(-pSwing.getWidth() - 2.0, 0.0);
            jButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    qWIPanel.getSchrodingerScreenNode().removeSavedScreenGraphic(SavedScreenGraphic.this);
                }
            });
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }
}

