/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.quantumwaveinterference.view.piccolo;

import edu.colorado.phet.common.phetcommon.util.SimpleObserver;
import edu.colorado.phet.common.phetcommon.view.util.PhetFont;
import edu.colorado.phet.quantumwaveinterference.QWILookAndFeel;
import edu.colorado.phet.quantumwaveinterference.model.potentials.RectangularPotential;
import edu.colorado.phet.quantumwaveinterference.view.QWIPanel;
import edu.colorado.phet.quantumwaveinterference.view.piccolo.RectangleGraphic;
import edu.umd.cs.piccolo.event.PDragEventHandler;
import edu.umd.cs.piccolo.event.PInputEvent;
import edu.umd.cs.piccolo.nodes.PText;
import edu.umd.cs.piccolox.pswing.PSwing;
import java.awt.Color;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;

public class RectangularPotentialGraphic
extends RectangleGraphic {
    private RectangularPotential potential;
    private PText potDisplay;
    private PSwing closeGraphic;

    public RectangularPotentialGraphic(QWIPanel qWIPanel, RectangularPotential rectangularPotential) {
        super(qWIPanel, rectangularPotential, new Color(255, 30, 0, 45));
        this.potential = rectangularPotential;
        this.potDisplay = new PText("");
        this.potDisplay.setFont(new PhetFont(1, 14));
        this.potDisplay.setTextPaint(Color.blue);
        this.potDisplay.setPickable(false);
        this.potDisplay.setChildrenPickable(false);
        this.addChild(this.potDisplay);
        this.addInputEventListener(new PDragEventHandler(){

            protected void drag(PInputEvent pInputEvent) {
                RectangularPotentialGraphic.this.updateGraphics();
            }
        });
        rectangularPotential.addObserver(new SimpleObserver(){

            public void update() {
                RectangularPotentialGraphic.this.update();
            }
        });
        JButton jButton = QWILookAndFeel.createCloseButton();
        jButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                RectangularPotentialGraphic.this.remove();
            }
        });
        this.closeGraphic = new PSwing(jButton);
        this.addChild(this.closeGraphic);
        this.closeGraphic.setOffset(-this.closeGraphic.getWidth() - 2.0, 0.0);
        this.update();
        this.updateGraphics();
    }

    protected void disableCloseGraphic() {
        this.closeGraphic.setVisible(false);
        this.closeGraphic.setPickable(false);
        this.closeGraphic.setChildrenPickable(false);
    }

    protected void disablePotentialDisplayGraphic() {
        this.potDisplay.setVisible(false);
        this.potDisplay.setPickable(false);
        this.potDisplay.setChildrenPickable(false);
    }

    private void updateGraphics() {
        super.getSchrodingerPanel().updateWaveGraphic();
    }

    private void remove() {
        super.getSchrodingerPanel().getSchrodingerModule().removePotential(this);
    }

    protected void update() {
        super.update();
        if (this.potential != null) {
            Rectangle rectangle = this.potential.getBounds();
            Rectangle rectangle2 = super.getViewRectangle(rectangle);
            this.potDisplay.setText("");
            this.potDisplay.setOffset((int)rectangle2.getX(), (int)rectangle2.getY());
            this.closeGraphic.setOffset((double)((int)rectangle2.getX()) - this.closeGraphic.getWidth() - 2.0, (int)rectangle2.getY());
        }
    }

    public RectangularPotential getPotential() {
        return this.potential;
    }
}

