/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.quantumwaveinterference.view.gun;

import edu.colorado.phet.quantumwaveinterference.QWIResources;
import edu.colorado.phet.quantumwaveinterference.phetcommon.ImagePComboBox;
import edu.colorado.phet.quantumwaveinterference.view.QWIPanel;
import edu.colorado.phet.quantumwaveinterference.view.gun.AbstractGunNode;
import edu.colorado.phet.quantumwaveinterference.view.gun.AutoFire;
import edu.colorado.phet.quantumwaveinterference.view.gun.AutoFireCheckBox;
import edu.colorado.phet.quantumwaveinterference.view.gun.DefaultGunParticle;
import edu.colorado.phet.quantumwaveinterference.view.gun.FireParticle;
import edu.colorado.phet.quantumwaveinterference.view.gun.GunControlPanel;
import edu.colorado.phet.quantumwaveinterference.view.gun.GunParticle;
import edu.colorado.phet.quantumwaveinterference.view.gun.Photon;
import edu.colorado.phet.quantumwaveinterference.view.gun.PhotonBeam;
import edu.colorado.phet.quantumwaveinterference.view.gun.PhotonBeamParticle;
import edu.colorado.phet.quantumwaveinterference.view.gun.PlainFireButton;
import java.awt.Point;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ArrayList;
import java.util.Map;
import javax.swing.JCheckBox;
import javax.swing.JComponent;

public class SingleParticleGunNode
extends AbstractGunNode
implements FireParticle {
    private PlainFireButton fireOne;
    private GunParticle gunParticle;
    private GunParticle[] gunParticles;
    private AutoFire autoFire;
    private PhotonBeamParticle photonBeamParticle;
    protected final JCheckBox autoFireJCheckBox;
    private GunControlPanel gunControlPanel;
    private ArrayList listeners = new ArrayList();

    public SingleParticleGunNode(QWIPanel qWIPanel) {
        super(qWIPanel);
        this.fireOne = new PlainFireButton(this, this);
        this.fireOne.addButtonEnableDisable();
        this.autoFire = new AutoFire(this, qWIPanel.getIntensityDisplay());
        this.autoFireJCheckBox = new AutoFireCheckBox(this.autoFire);
        this.gunControlPanel = this.createGunControlPanel();
        this.setGunParticle(this.gunParticles[0]);
        this.setOnGunControl(this.fireOne);
    }

    private GunControlPanel createGunControlPanel() {
        GunControlPanel gunControlPanel = new GunControlPanel(this.getSchrodingerPanel());
        gunControlPanel.setFillNone();
        gunControlPanel.add(this.autoFireJCheckBox);
        return gunControlPanel;
    }

    protected Point getGunLocation() {
        if (this.gunParticle != null) {
            return this.gunParticle.getGunLocation();
        }
        return new Point();
    }

    public void clearAndFire() {
        this.clearWavefunction();
        this.fireParticle();
        this.fireOne.setEnabled(false);
    }

    private void clearWavefunction() {
        this.getDiscreteModel().clearWavefunction();
    }

    public void fireParticle() {
        this.gunParticle.fireParticle();
        this.notifyGunFired();
    }

    public GunParticle getGunParticle() {
        return this.gunParticle;
    }

    protected void setGunParticle(GunParticle gunParticle) {
        if (gunParticle != this.gunParticle) {
            this.getDiscreteModel().clearWavefunction();
            if (this.gunParticle != null) {
                this.gunParticle.deactivate(this);
            }
            gunParticle.activate(this);
            this.gunParticle = gunParticle;
        }
        this.updateGunLocation();
        this.getSchrodingerModule().beamTypeChanged();
        this.notifyGunParticleTypeChanged();
    }

    public void addSingleParticleGunNodeListener(SingleParticleGunNodeListener singleParticleGunNodeListener) {
        this.listeners.add(singleParticleGunNodeListener);
    }

    public void notifyGunParticleTypeChanged() {
        for (int i = 0; i < this.listeners.size(); ++i) {
            SingleParticleGunNodeListener singleParticleGunNodeListener = (SingleParticleGunNodeListener)this.listeners.get(i);
            singleParticleGunNodeListener.gunParticleTypeChanged();
        }
    }

    protected ImagePComboBox initComboBox() {
        Photon photon = new Photon(this, QWIResources.getString("particles.photons"), "quantum-wave-interference/images/photon-thumb.png");
        PhotonBeam photonBeam = new PhotonBeam(this, photon);
        this.photonBeamParticle = new PhotonBeamParticle((AbstractGunNode)this, QWIResources.getString("particles.photons"), photonBeam);
        this.gunParticles = new GunParticle[]{this.photonBeamParticle, DefaultGunParticle.createElectron(this), DefaultGunParticle.createNeutron(this), DefaultGunParticle.createHelium(this)};
        final ImagePComboBox imagePComboBox = new ImagePComboBox(this.gunParticles);
        imagePComboBox.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent itemEvent) {
                int n = imagePComboBox.getSelectedIndex();
                SingleParticleGunNode.this.setGunParticle(SingleParticleGunNode.this.gunParticles[n]);
            }
        });
        return imagePComboBox;
    }

    protected void setGunControls(JComponent jComponent) {
        this.gunControlPanel.setGunControls(jComponent);
    }

    public void reset() {
        this.photonBeamParticle.reset();
    }

    public Map getModelParameters() {
        Map map = super.getModelParameters();
        map.putAll(this.gunParticle.getModelParameters());
        return map;
    }

    public GunControlPanel getGunControlPanel() {
        return this.gunControlPanel;
    }

    public boolean isPhotonMode() {
        return this.gunParticle instanceof PhotonBeamParticle;
    }

    public boolean isFiring() {
        return this.gunParticle.isFiring();
    }

    public static interface SingleParticleGunNodeListener {
        public void gunParticleTypeChanged();
    }
}

