/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.quantumwaveinterference.view.gun;

import edu.colorado.phet.common.phetcommon.model.ModelElement;
import edu.colorado.phet.common.phetcommon.view.util.ImageLoader;
import edu.colorado.phet.common.phetcommon.view.util.PhetFont;
import edu.colorado.phet.common.piccolophet.event.CursorHandler;
import edu.colorado.phet.common.piccolophet.nodes.ShadowPText;
import edu.colorado.phet.quantumwaveinterference.QWIModule;
import edu.colorado.phet.quantumwaveinterference.QWIResources;
import edu.colorado.phet.quantumwaveinterference.view.QWIPanel;
import edu.colorado.phet.quantumwaveinterference.view.gun.FireParticle;
import edu.colorado.phet.quantumwaveinterference.view.gun.SingleParticleGunNode;
import edu.umd.cs.piccolo.PNode;
import edu.umd.cs.piccolo.event.PBasicInputEventHandler;
import edu.umd.cs.piccolo.event.PInputEvent;
import edu.umd.cs.piccolo.nodes.PImage;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.image.BufferedImage;
import java.io.IOException;

public class PlainFireButton
extends PNode {
    private BufferedImage outIcon;
    private BufferedImage inIcon;
    private PImage icon;
    private ShadowPText text;
    private SingleParticleGunNode gun;
    private FireParticle fireParticle;
    private boolean enabled = true;
    private BufferedImage grayIcon;

    public PlainFireButton(SingleParticleGunNode singleParticleGunNode, FireParticle fireParticle) {
        this.gun = singleParticleGunNode;
        this.fireParticle = fireParticle;
        this.icon = new PImage();
        this.text = new ShadowPText(QWIResources.getString("gun.FIRE"));
        this.text.setShadowOffset(1.0, 1.0);
        this.text.setShadowColor(Color.black);
        this.text.setFont(new PhetFont(1, 12));
        this.text.setTextPaint(Color.red);
        try {
            this.outIcon = ImageLoader.loadBufferedImage("quantum-wave-interference/images/button-out-40.gif");
            this.inIcon = ImageLoader.loadBufferedImage("quantum-wave-interference/images/button-in-40.gif");
            this.grayIcon = ImageLoader.loadBufferedImage("quantum-wave-interference/images/button-out-40-gray.gif");
            this.icon = new PImage(this.outIcon);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        this.setIcon(this.outIcon);
        this.addChild(this.icon);
        this.addChild(this.text);
        this.text.setOffset(this.icon.getFullBounds().getWidth() / 2.0 - this.text.getFullBounds().getWidth() / 2.0, this.icon.getFullBounds().getHeight());
        this.addInputEventListener(new PBasicInputEventHandler(){

            public void mousePressed(PInputEvent pInputEvent) {
                if (PlainFireButton.this.fireButtonEnabled()) {
                    PlainFireButton.this.setIcon(PlainFireButton.this.inIcon);
                    PlainFireButton.this.pullback();
                }
            }

            public void mouseReleased(PInputEvent pInputEvent) {
                PlainFireButton.this.releasePullback();
                PlainFireButton.this.fireParticle();
            }
        });
        this.addInputEventListener(new CursorHandler());
    }

    private void setIcon(BufferedImage bufferedImage) {
        this.icon.setImage(bufferedImage);
    }

    private void releasePullback() {
        if (this.fireButtonEnabled()) {
            this.updateGunLocation();
        }
    }

    private void pullback() {
        if (this.fireButtonEnabled()) {
            this.updateGunLocation();
            this.getGunImageGraphic().translate(0.0, 10.0);
        }
    }

    private void fireParticle() {
        this.clearAndFire();
        this.setIcon(this.inIcon);
        this.updateGunLocation();
        this.getSchrodingerPanel().setCursor(Cursor.getPredefinedCursor(0));
    }

    public void addButtonEnableDisable() {
        this.getSchrodingerModule().getModel().addModelElement(new ModelElement(){

            public void stepInTime(double d) {
                double d2 = PlainFireButton.this.getSchrodingerModule().getQWIModel().getWavefunction().getMagnitude();
                if ((d2 <= 0.04 || Double.isNaN(d2)) && !PlainFireButton.this.gun.isFiring()) {
                    if (!PlainFireButton.this.fireButtonEnabled()) {
                        PlainFireButton.this.setEnabled(true);
                    }
                } else if (PlainFireButton.this.fireButtonEnabled()) {
                    PlainFireButton.this.setEnabled(false);
                }
            }
        });
    }

    public void setEnabled(boolean bl) {
        this.enabled = bl;
        this.setIcon(this.enabled ? this.outIcon : this.inIcon);
    }

    private boolean fireButtonEnabled() {
        return this.enabled;
    }

    private QWIModule getSchrodingerModule() {
        return this.fireParticle.getSchrodingerModule();
    }

    private QWIPanel getSchrodingerPanel() {
        return this.getSchrodingerModule().getSchrodingerPanel();
    }

    private void updateGunLocation() {
        this.fireParticle.updateGunLocation();
    }

    private void clearAndFire() {
        this.fireParticle.clearAndFire();
    }

    private PNode getGunImageGraphic() {
        return this.fireParticle.getGunImageGraphic();
    }
}

