/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.quantumwaveinterference.view.gun;

import edu.colorado.phet.common.phetcommon.math.Function;
import edu.colorado.phet.common.phetcommon.model.ModelElement;
import edu.colorado.phet.common.phetcommon.view.util.PhetFont;
import edu.colorado.phet.common.piccolophet.event.CursorHandler;
import edu.colorado.phet.quantumwaveinterference.QWIResources;
import edu.colorado.phet.quantumwaveinterference.controls.IntensitySlider;
import edu.colorado.phet.quantumwaveinterference.phetcommon.ImagePComboBox;
import edu.colorado.phet.quantumwaveinterference.view.QWIPanel;
import edu.colorado.phet.quantumwaveinterference.view.colormaps.ColorData;
import edu.colorado.phet.quantumwaveinterference.view.gun.AbstractGunNode;
import edu.colorado.phet.quantumwaveinterference.view.gun.DefaultGunParticle;
import edu.colorado.phet.quantumwaveinterference.view.gun.GunControlPanel;
import edu.colorado.phet.quantumwaveinterference.view.gun.IntensityBeam;
import edu.colorado.phet.quantumwaveinterference.view.gun.OnOffCheckBox;
import edu.colorado.phet.quantumwaveinterference.view.gun.OnOffItem;
import edu.colorado.phet.quantumwaveinterference.view.gun.ParticleBeam;
import edu.colorado.phet.quantumwaveinterference.view.gun.Photon;
import edu.colorado.phet.quantumwaveinterference.view.gun.PhotonBeam;
import edu.colorado.phet.quantumwaveinterference.view.piccolo.BlueGunDetails;
import edu.umd.cs.piccolo.nodes.PText;
import edu.umd.cs.piccolox.pswing.PSwing;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class IntensityGunNode
extends AbstractGunNode
implements OnOffItem {
    protected OnOffCheckBox alwaysOnCheckBox;
    protected IntensitySlider intensitySlider;
    private boolean on = false;
    private IntensityBeam[] beams;
    private IntensityBeam currentBeam;
    private Photon photon;
    private GunControlPanel gunControlPanel;
    private PSwing onPswing;
    private PText onOffTextNode = new PText(QWIResources.getString("gun.off"));

    protected IntensitySlider getIntensitySlider() {
        return this.intensitySlider;
    }

    protected JCheckBox getAlwaysOnCheckBox() {
        return this.alwaysOnCheckBox;
    }

    public IntensityGunNode(QWIPanel qWIPanel) {
        super(qWIPanel);
        this.onOffTextNode.setFont(new PhetFont(12, true));
        this.alwaysOnCheckBox = new OnOffCheckBox(this);
        this.addChild(this.onOffTextNode);
        this.intensitySlider = new IntensitySlider(Color.white, IntensitySlider.HORIZONTAL, new Dimension(140, 30));
        this.intensitySlider.setValue(100);
        this.intensitySlider.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                IntensityGunNode.this.updateIntensity();
            }
        });
        this.updateIntensity();
        qWIPanel.getSchrodingerModule().getModel().addModelElement(new ModelElement(){

            public void stepInTime(double d) {
                IntensityGunNode.this.stepBeam();
            }
        });
        this.gunControlPanel = this.createGunControlPanel();
        this.setupObject(this.beams[0]);
        this.alwaysOnCheckBox.setBackground(BlueGunDetails.gunBackgroundColor);
        this.onPswing = new PSwing(this.alwaysOnCheckBox);
        this.onPswing.addInputEventListener(new CursorHandler());
        this.setOnGunControl(this.onPswing);
        this.updateSliderColor();
    }

    protected void setOnOffTextVisible(boolean bl) {
        this.onOffTextNode.setVisible(bl);
    }

    protected GunControlPanel createGunControlPanel() {
        GunControlPanel gunControlPanel = new GunControlPanel(this.getSchrodingerPanel());
        gunControlPanel.add(this.intensitySlider);
        return gunControlPanel;
    }

    protected void layoutChildren() {
        super.layoutChildren();
        if (this.onOffTextNode != null) {
            this.onOffTextNode.setOffset(this.getOnGunGraphic().getFullBounds().getCenterX() - this.onOffTextNode.getFullBounds().getWidth() / 2.0, this.getOnGunGraphic().getFullBounds().getMaxY());
        }
    }

    protected Point getGunLocation() {
        if (this.currentBeam != null) {
            return this.currentBeam.getGunLocation();
        }
        return new Point();
    }

    private void stepBeam() {
        this.currentBeam.stepBeam();
    }

    protected ImagePComboBox initComboBox() {
        this.photon = new Photon(this, QWIResources.getString("particles.photons"), "quantum-wave-interference/images/photon-thumb.png");
        IntensityBeam[] intensityBeamArray = new IntensityBeam[]{new PhotonBeam(this, this.photon), new ParticleBeam(DefaultGunParticle.createElectron(this)), new ParticleBeam(DefaultGunParticle.createNeutron(this)), new ParticleBeam(DefaultGunParticle.createHelium(this))};
        this.setBeams(intensityBeamArray);
        final ImagePComboBox imagePComboBox = new ImagePComboBox(this.beams);
        imagePComboBox.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent itemEvent) {
                int n = imagePComboBox.getSelectedIndex();
                IntensityGunNode.this.setupObject(IntensityGunNode.this.beams[n]);
            }
        });
        this.photon.addMomentumChangeListerner(new AbstractGunNode.MomentumChangeListener(){

            public void momentumChanged(double d) {
                IntensityGunNode.this.updateSliderColor();
            }
        });
        return imagePComboBox;
    }

    protected void setGunControls(JComponent jComponent) {
        this.gunControlPanel.setGunControls(jComponent);
    }

    public GunControlPanel getGunControlPanel() {
        return this.gunControlPanel;
    }

    public boolean isPhotonMode() {
        return this.currentBeam instanceof PhotonBeam;
    }

    protected void setBeams(IntensityBeam[] intensityBeamArray) {
        this.beams = intensityBeamArray;
    }

    public void setupObject(IntensityBeam intensityBeam) {
        if (intensityBeam != this.currentBeam) {
            this.getDiscreteModel().clearWavefunction();
            if (this.currentBeam != null) {
                this.currentBeam.deactivate(this);
            }
            intensityBeam.activate(this);
            this.currentBeam = intensityBeam;
            this.currentBeam.setHighIntensityModeOn(this.on);
        }
        this.getSchrodingerModule().beamTypeChanged();
        this.updateGunLocation();
        this.updateSliderColor();
    }

    private void updateIntensity() {
        double d = new Function.LinearFunction(0.0, 40.0, 0.0, 0.5).evaluate(this.intensitySlider.getValue());
        for (int i = 0; i < this.beams.length; ++i) {
            this.beams[i].setIntensity(d);
        }
    }

    public void setOn(boolean bl) {
        this.on = bl;
        if (this.currentBeam != null) {
            this.currentBeam.setHighIntensityModeOn(bl);
        }
        this.onOffTextNode.setText(bl ? QWIResources.getString("gun.on") : QWIResources.getString("gun.off"));
        this.onOffTextNode.setTextPaint(bl ? Color.red : Color.black);
    }

    public boolean isOn() {
        return this.on;
    }

    public ColorData getRootColor() {
        return this.photon == null ? null : this.photon.getRootColor();
    }

    private void updateSliderColor() {
        this.intensitySlider.setColor(this.currentBeam instanceof PhotonBeam && this.getRootColor() != null ? this.getRootColor().toColor(1.0) : Color.white);
    }
}

