/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.quantumwaveinterference.view.gun;

import edu.colorado.phet.common.phetcommon.math.Vector2D;
import edu.colorado.phet.quantumwaveinterference.QWIModule;
import edu.colorado.phet.quantumwaveinterference.model.QWIModel;
import edu.colorado.phet.quantumwaveinterference.model.WaveSetup;
import edu.colorado.phet.quantumwaveinterference.model.Wavefunction;
import edu.colorado.phet.quantumwaveinterference.model.waves.GaussianWave2D;
import edu.colorado.phet.quantumwaveinterference.phetcommon.ImageComboBox;
import edu.colorado.phet.quantumwaveinterference.view.gun.AbstractGunNode;
import java.awt.Point;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public abstract class GunParticle
extends ImageComboBox.Item {
    private AbstractGunNode gunNode;
    private ArrayList momentumChangeListeners = new ArrayList();
    private double intensityScale = 1.0;
    protected boolean active = false;
    private ArrayList changeHandlers = new ArrayList();

    public GunParticle(AbstractGunNode abstractGunNode, String string, String string2) {
        super(string, string2);
        this.gunNode = abstractGunNode;
    }

    public abstract void activate(AbstractGunNode var1);

    public abstract void deactivate(AbstractGunNode var1);

    public AbstractGunNode getGunGraphic() {
        return this.gunNode;
    }

    public abstract double getStartPy();

    public WaveSetup getInitialWavefunction(Wavefunction wavefunction) {
        double d = (double)this.getDiscreteModel().getGridWidth() * 0.5;
        double d2 = this.getStartY();
        double d3 = 0.0;
        double d4 = this.getStartPy();
        Point point = new Point((int)d, (int)(d2 - 5.0));
        if (point.y >= wavefunction.getHeight()) {
            point.y = wavefunction.getHeight() - 1;
        }
        if (point.y < 0) {
            point.y = 0;
        }
        double d5 = this.getStartDxLattice();
        GaussianWave2D gaussianWave2D = new GaussianWave2D(new Point((int)d, (int)d2), new Vector2D(d3, d4), d5, this.getHBar());
        double d6 = wavefunction.valueAt(point.x, point.y).getComplexPhase();
        Wavefunction wavefunction2 = wavefunction.createEmptyWavefunction();
        gaussianWave2D.initialize(wavefunction2);
        double d7 = wavefunction2.valueAt(point.x, point.y).getComplexPhase();
        double d8 = d6 - d7;
        gaussianWave2D.setPhase(d8);
        gaussianWave2D.setScale(this.getIntensityScale() * this.getWaveAreaSizeScale());
        return gaussianWave2D;
    }

    private double getWaveAreaSizeScale() {
        return this.getDiscreteModel().getGridHeight() / 45;
    }

    protected abstract double getHBar();

    public double getIntensityScale() {
        return this.intensityScale;
    }

    protected double getStartY() {
        return (double)this.getDiscreteModel().getGridHeight() * 0.85;
    }

    public void fireParticle() {
        WaveSetup waveSetup = this.getInitialWavefunction(this.getDiscreteModel().getWavefunction());
        this.getSchrodingerModule().fireParticle(waveSetup);
    }

    QWIModule getSchrodingerModule() {
        return this.gunNode.getSchrodingerModule();
    }

    protected QWIModel getDiscreteModel() {
        return this.getSchrodingerModule().getQWIModel();
    }

    protected double getStartDxLattice() {
        return 0.06 * (double)this.getDiscreteModel().getGridWidth();
    }

    public Point getGunLocation() {
        return new Point(-10, 35);
    }

    public Map getModelParameters() {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("startDXLattice", "" + this.getStartDxLattice());
        return hashMap;
    }

    public abstract boolean isFiring();

    public boolean isActive() {
        return this.active;
    }

    public abstract double getMinimumProbabilityForDetection();

    public abstract boolean getTimeThresholdAllowed();

    public abstract int getTimeThresholdCount();

    public void addMomentumChangeListerner(AbstractGunNode.MomentumChangeListener momentumChangeListener) {
        this.momentumChangeListeners.add(momentumChangeListener);
        ChangeHandler changeHandler = new ChangeHandler(momentumChangeListener);
        this.changeHandlers.add(changeHandler);
        this.hookupListener(changeHandler);
    }

    public void removeMomentumChangeListener(AbstractGunNode.MomentumChangeListener momentumChangeListener) {
        ChangeHandler changeHandler;
        int n;
        this.momentumChangeListeners.remove(momentumChangeListener);
        ArrayList<ChangeHandler> arrayList = new ArrayList<ChangeHandler>();
        for (n = 0; n < this.changeHandlers.size(); ++n) {
            changeHandler = (ChangeHandler)this.changeHandlers.get(n);
            if (changeHandler.momentumChangeListener != momentumChangeListener) continue;
            arrayList.add(changeHandler);
        }
        for (n = 0; n < arrayList.size(); ++n) {
            changeHandler = (ChangeHandler)arrayList.get(n);
            this.changeHandlers.remove(changeHandler);
            this.detachListener(changeHandler);
        }
    }

    protected abstract void detachListener(ChangeHandler var1);

    protected abstract void hookupListener(ChangeHandler var1);

    protected void notifyMomentumChanged() {
        double d = this.getStartPy();
        for (int i = 0; i < this.momentumChangeListeners.size(); ++i) {
            AbstractGunNode.MomentumChangeListener momentumChangeListener = (AbstractGunNode.MomentumChangeListener)this.momentumChangeListeners.get(i);
            momentumChangeListener.momentumChanged(d);
        }
    }

    public void autofire() {
        this.fireParticle();
    }

    public void setIntensityScale(double d) {
        this.intensityScale = d;
    }

    protected class ChangeHandler
    implements ChangeListener {
        private AbstractGunNode.MomentumChangeListener momentumChangeListener;

        public ChangeHandler(AbstractGunNode.MomentumChangeListener momentumChangeListener) {
            this.momentumChangeListener = momentumChangeListener;
        }

        public void stateChanged(ChangeEvent changeEvent) {
            GunParticle.this.notifyMomentumChanged();
        }
    }
}

