/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.quantumwaveinterference.view.colormaps;

import edu.colorado.phet.quantumwaveinterference.model.Wavefunction;

public interface WaveValueAccessor {
    public double getValue(Wavefunction var1, int var2, int var3);

    public static class Empty
    implements WaveValueAccessor {
        public double getValue(Wavefunction wavefunction, int n, int n2) {
            return 0.0;
        }
    }

    public static class Imag
    implements WaveValueAccessor {
        public double getValue(Wavefunction wavefunction, int n, int n2) {
            return Math.abs(wavefunction.valueAt(n, n2).getImaginary());
        }
    }

    public static class Magnitude
    implements WaveValueAccessor {
        public double getValue(Wavefunction wavefunction, int n, int n2) {
            return wavefunction.valueAt(n, n2).abs();
        }
    }

    public static class Real
    implements WaveValueAccessor {
        public double getValue(Wavefunction wavefunction, int n, int n2) {
            return Math.abs(wavefunction.valueAt(n, n2).getReal());
        }
    }
}

