/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.quantumwaveinterference.phetcommon;

import edu.colorado.phet.quantumwaveinterference.phetcommon.ShinyBorder;
import java.awt.Color;
import java.awt.Component;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.ContainerEvent;
import java.awt.event.ContainerListener;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.SwingUtilities;
import javax.swing.text.JTextComponent;

public class ShinyPanel
extends JPanel {
    private Color lightGray;
    private Color shadedGray;

    public ShinyPanel(JComponent jComponent) {
        this(jComponent, new Color(192, 192, 192), new Color(228, 228, 228));
    }

    public ShinyPanel(JComponent jComponent, Color color, Color color2) {
        this.lightGray = color;
        this.shadedGray = color2;
        this.add(jComponent);
        this.init(this, false);
        this.setBorder(new ShinyBorder());
        this.initListeners(jComponent);
    }

    private void initListeners(JComponent jComponent) {
        jComponent.addComponentListener(new ComponentListener(){

            public void componentHidden(ComponentEvent componentEvent) {
            }

            public void componentMoved(ComponentEvent componentEvent) {
                ShinyPanel.this.relayout();
            }

            public void componentResized(ComponentEvent componentEvent) {
                ShinyPanel.this.relayout();
            }

            public void componentShown(ComponentEvent componentEvent) {
                ShinyPanel.this.relayout();
            }
        });
        jComponent.addContainerListener(new ContainerListener(){

            public void componentAdded(ContainerEvent containerEvent) {
                ShinyPanel.this.relayout();
            }

            public void componentRemoved(ContainerEvent containerEvent) {
                ShinyPanel.this.relayout();
            }
        });
    }

    private void relayout() {
        this.layoutAll();
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                ShinyPanel.this.layoutAll();
            }
        });
    }

    private void layoutAll() {
        this.invalidate();
        this.validate();
        this.revalidate();
        this.doLayout();
        this.repaint();
    }

    private void init(JComponent jComponent, boolean bl) {
        jComponent.setOpaque(bl);
        if (jComponent instanceof JSlider) {
            jComponent.setBackground(new Color(0, 0, 0, 0));
        }
        this.initListeners(jComponent);
        for (int i = 0; i < jComponent.getComponentCount(); ++i) {
            Component component = jComponent.getComponent(i);
            if (!(component instanceof JComponent) || component instanceof JTextComponent) continue;
            this.init((JComponent)component, bl);
        }
    }

    protected void paintComponent(Graphics graphics) {
        GradientPaint gradientPaint = new GradientPaint(0.0f, 0.0f, this.lightGray, this.getWidth() / 2, this.getHeight() / 2, this.shadedGray, true);
        Graphics2D graphics2D = (Graphics2D)graphics;
        graphics2D.setPaint(gradientPaint);
        graphics2D.fillRect(0, 0, this.getWidth(), this.getHeight());
        super.paintComponent(graphics);
    }

    public void update() {
        this.init(this, false);
    }
}

