/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.quantumwaveinterference.phetcommon;

import edu.colorado.phet.common.phetcommon.view.util.ImageLoader;
import edu.colorado.phet.common.piccolophet.PhetPNode;
import edu.colorado.phet.common.piccolophet.event.CursorHandler;
import edu.colorado.phet.quantumwaveinterference.QWILookAndFeel;
import edu.colorado.phet.quantumwaveinterference.model.QWIModel;
import edu.colorado.phet.quantumwaveinterference.phetcommon.HalfOnscreenDragHandler;
import edu.colorado.phet.quantumwaveinterference.phetcommon.RulerGraphic;
import edu.umd.cs.piccolo.PNode;
import edu.umd.cs.piccolo.util.PBounds;
import edu.umd.cs.piccolox.pswing.PSwing;
import edu.umd.cs.piccolox.pswing.PSwingCanvas;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.geom.Rectangle2D;
import java.io.IOException;
import javax.swing.ImageIcon;
import javax.swing.JButton;

public class SchrodingerRulerGraphic
extends PhetPNode {
    private QWIModel QWIModel;
    public RulerGraphic rulerGraphic;
    boolean horizontal = true;
    private PSwingCanvas component;

    public SchrodingerRulerGraphic(QWIModel qWIModel, final PSwingCanvas pSwingCanvas, final RulerGraphic rulerGraphic) {
        this.component = pSwingCanvas;
        this.QWIModel = qWIModel;
        this.rulerGraphic = rulerGraphic;
        this.addChild(this.rulerGraphic);
        JButton jButton = this.createRotateButton();
        PSwing pSwing = new PSwing(jButton);
        this.addChild(pSwing);
        pSwing.addInputEventListener(new CursorHandler(12));
        pSwing.setOffset(-2.0 - pSwing.getWidth(), 0.0);
        JButton jButton2 = this.createCloseButton();
        PSwing pSwing2 = new PSwing(jButton2);
        this.addChild(pSwing2);
        pSwing2.addInputEventListener(new CursorHandler(12));
        pSwing2.setOffset(pSwing.getX(), pSwing.getY() - pSwing.getHeight() - 2.0);
        this.addInputEventListener(new CursorHandler(12));
        this.addInputEventListener(new HalfOnscreenDragHandler(pSwingCanvas, (PNode)this));
        pSwingCanvas.addComponentListener(new ComponentAdapter(){

            public void componentResized(ComponentEvent componentEvent) {
                SchrodingerRulerGraphic.this.rotate();
                SchrodingerRulerGraphic.this.rotate();
            }
        });
        pSwingCanvas.addComponentListener(new ComponentAdapter(){

            public void componentResized(ComponentEvent componentEvent) {
                PBounds pBounds = rulerGraphic.getGlobalFullBounds();
                Rectangle2D.Double double_ = new Rectangle2D.Double(0.0, 0.0, pSwingCanvas.getWidth(), pSwingCanvas.getHeight());
                if (!double_.intersects(pBounds)) {
                    SchrodingerRulerGraphic.this.setOffset(100.0, 100.0);
                }
            }
        });
    }

    private JButton createCloseButton() {
        JButton jButton = QWILookAndFeel.createCloseButton();
        jButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                SchrodingerRulerGraphic.this.close();
            }
        });
        return jButton;
    }

    private void close() {
        this.setVisible(false);
    }

    private JButton createRotateButton() {
        JButton jButton = null;
        try {
            jButton = new JButton(new ImageIcon(ImageLoader.loadBufferedImage("quantum-wave-interference/images/rot.jpg")));
            jButton.setMargin(new Insets(1, 1, 1, 1));
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        jButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                SchrodingerRulerGraphic.this.rotate();
            }
        });
        return jButton;
    }

    private void rotate() {
        boolean bl = this.horizontal = !this.horizontal;
        if (this.horizontal) {
            this.rulerGraphic.setRotation(0.0);
            this.rulerGraphic.setOffset(0.0, 0.0);
        } else {
            this.rulerGraphic.setRotation(-1.5707963267948966);
            this.rulerGraphic.setOffset(0.0, this.rulerGraphic.getWidth());
        }
    }

    public void setUnits(String string) {
        this.rulerGraphic.setUnitsText(string);
    }

    public RulerGraphic getRulerGraphic() {
        return this.rulerGraphic;
    }
}

