/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.quantumwaveinterference.persistence;

import edu.colorado.phet.common.phetcommon.application.PhetApplication;
import edu.colorado.phet.common.phetcommon.util.IProguardKeepClass;
import edu.colorado.phet.common.phetcommon.view.PhetFrame;
import edu.colorado.phet.common.phetcommon.view.util.PhetOptionPane;
import edu.colorado.phet.quantumwaveinterference.QWIResources;
import java.awt.Window;
import java.beans.ExceptionListener;
import java.beans.XMLDecoder;
import java.beans.XMLEncoder;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.text.MessageFormat;
import javax.jnlp.FileContents;
import javax.jnlp.FileOpenService;
import javax.jnlp.FileSaveService;
import javax.jnlp.ServiceManager;
import javax.jnlp.UnavailableServiceException;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.SwingUtilities;

public class PersistenceManager
implements IProguardKeepClass {
    private String _directoryName;
    private boolean _useJNLP;
    private JComponent parent;

    public PersistenceManager(JComponent jComponent) {
        this.parent = jComponent;
        this._useJNLP = PersistenceManager.wasWebStarted();
    }

    public void save(Serializable serializable) {
        try {
            if (this._useJNLP) {
                this.saveJNLP(serializable);
            } else {
                this.saveLocal(serializable);
            }
        }
        catch (Exception exception) {
            this.showError(QWIResources.getString("Save.error.message"), exception);
        }
    }

    public Object load() throws IOException, UnavailableServiceException {
        if (this._useJNLP) {
            return this.loadJNLP();
        }
        return this.loadLocal();
    }

    public void saveLocal(Object object) throws Exception {
        Object object2;
        String string;
        Window window = this.getFrame();
        JFileChooser jFileChooser = new JFileChooser(this._directoryName);
        jFileChooser.setDialogTitle(QWIResources.getString("save"));
        int n = jFileChooser.showSaveDialog(window);
        this._directoryName = jFileChooser.getCurrentDirectory().getAbsolutePath();
        File file = jFileChooser.getSelectedFile();
        if (n == 1 || file == null) {
            return;
        }
        this._directoryName = file.getParentFile().getAbsolutePath();
        if (file.exists()) {
            string = QWIResources.getString("confirm");
            object2 = QWIResources.getString("confirm.save");
            int n2 = PhetOptionPane.showYesNoDialog(window, object2, string);
            if (n2 != 0) {
                return;
            }
        }
        string = file.getAbsolutePath();
        object2 = new FileOutputStream(string);
        BufferedOutputStream bufferedOutputStream = new BufferedOutputStream((OutputStream)object2);
        XMLEncoder xMLEncoder = new XMLEncoder(bufferedOutputStream);
        xMLEncoder.setExceptionListener(new ExceptionListener(){
            private int errors = 0;

            public void exceptionThrown(Exception exception) {
                if (this.errors == 0) {
                    PersistenceManager.this.showError(QWIResources.getString("Save.error.encode"), exception);
                    ++this.errors;
                }
            }
        });
        xMLEncoder.writeObject(object);
        xMLEncoder.close();
    }

    private Window getFrame() {
        return SwingUtilities.getWindowAncestor(this.parent);
    }

    public Object loadLocal() throws FileNotFoundException {
        Window window = this.getFrame();
        JFileChooser jFileChooser = new JFileChooser(this._directoryName);
        jFileChooser.setDialogTitle("Load File");
        int n = jFileChooser.showOpenDialog(window);
        this._directoryName = jFileChooser.getCurrentDirectory().getAbsolutePath();
        File file = jFileChooser.getSelectedFile();
        if (n == 1 || file == null) {
            return null;
        }
        Object object = null;
        String string = file.getAbsolutePath();
        FileInputStream fileInputStream = new FileInputStream(string);
        BufferedInputStream bufferedInputStream = new BufferedInputStream(fileInputStream);
        XMLDecoder xMLDecoder = new XMLDecoder(bufferedInputStream);
        xMLDecoder.setExceptionListener(new ExceptionListener(){
            private int errors = 0;

            public void exceptionThrown(Exception exception) {
                if (this.errors == 0) {
                    PersistenceManager.this.showError(QWIResources.getString("Load.error.decode"), exception);
                    ++this.errors;
                }
            }
        });
        object = xMLDecoder.readObject();
        xMLDecoder.close();
        return object;
    }

    private void saveJNLP(Serializable serializable) throws Exception {
        PhetFrame phetFrame = PhetApplication.getInstance().getPhetFrame();
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        XMLEncoder xMLEncoder = new XMLEncoder(byteArrayOutputStream);
        xMLEncoder.setExceptionListener(new ExceptionListener(){
            private int errors = 0;

            public void exceptionThrown(Exception exception) {
                if (this.errors == 0) {
                    PersistenceManager.this.showError(QWIResources.getString("Save.error.encode"), exception);
                    ++this.errors;
                }
            }
        });
        xMLEncoder.writeObject(serializable);
        xMLEncoder.close();
        if (serializable == null) {
            throw new Exception(QWIResources.getString("XML encoding failed"));
        }
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byteArrayOutputStream.toByteArray());
        FileSaveService fileSaveService = (FileSaveService)ServiceManager.lookup("javax.jnlp.FileSaveService");
        if (fileSaveService == null) {
            throw new UnavailableServiceException("JNLP FileSaveService is unavailable");
        }
        FileContents fileContents = fileSaveService.saveFileDialog(null, null, byteArrayInputStream, this._directoryName);
        if (fileContents != null) {
            this._directoryName = PersistenceManager.getDirectoryName(fileContents.getName());
        }
    }

    private Object loadJNLP() throws UnavailableServiceException, IOException {
        Window window = this.getFrame();
        FileOpenService fileOpenService = (FileOpenService)ServiceManager.lookup("javax.jnlp.FileOpenService");
        if (fileOpenService == null) {
            throw new UnavailableServiceException("JNLP FileOpenService is unavailable");
        }
        FileContents fileContents = fileOpenService.openFileDialog(this._directoryName, null);
        if (fileContents == null) {
            return null;
        }
        this._directoryName = PersistenceManager.getDirectoryName(fileContents.getName());
        InputStream inputStream = fileContents.getInputStream();
        Object object = null;
        XMLDecoder xMLDecoder = new XMLDecoder(inputStream);
        xMLDecoder.setExceptionListener(new ExceptionListener(){
            private int errors = 0;

            public void exceptionThrown(Exception exception) {
                if (this.errors == 0) {
                    PersistenceManager.this.showError(QWIResources.getString("Load.error.decode"), exception);
                    ++this.errors;
                }
            }
        });
        object = xMLDecoder.readObject();
        xMLDecoder.close();
        return object;
    }

    public static boolean wasWebStarted() {
        return System.getProperty("javawebstart.version") != null;
    }

    public void showError(String string, Exception exception) {
        this.showError(string, exception.getMessage());
        exception.printStackTrace();
    }

    public void showError(String string, String string2) {
        Window window = this.getFrame();
        Object[] objectArray = new Object[]{string2};
        String string3 = MessageFormat.format(string, objectArray);
        PhetOptionPane.showErrorDialog(window, string3);
    }

    public static String getDirectoryName(String string) {
        String string2 = null;
        int n = string.lastIndexOf(File.pathSeparatorChar);
        if (n != -1) {
            string2 = string.substring(n);
        }
        return string2;
    }

    public static void main(String[] stringArray) throws Exception {
        PersistenceManager persistenceManager = new PersistenceManager(new JButton());
        Object object = persistenceManager.load();
        System.out.println("o = " + object);
    }
}

