/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.quantumwaveinterference.modules.mandel;

import edu.colorado.phet.quantumwaveinterference.model.Propagator;
import edu.colorado.phet.quantumwaveinterference.model.QWIModel;
import edu.colorado.phet.quantumwaveinterference.model.Wave;
import edu.colorado.phet.quantumwaveinterference.model.WaveModel;
import edu.colorado.phet.quantumwaveinterference.model.Wavefunction;
import edu.colorado.phet.quantumwaveinterference.model.math.Complex;
import edu.colorado.phet.quantumwaveinterference.model.potentials.ConstantPotential;
import edu.colorado.phet.quantumwaveinterference.model.propagators.NullPropagator;

public class MandelModel
extends QWIModel {
    private WaveModel rightWaveModel = new WaveModel(new Wavefunction(this.getGridWidth(), this.getGridHeight()), new NullPropagator(new ConstantPotential()));
    private WaveModel leftWaveModel = new WaveModel(new Wavefunction(this.getGridWidth(), this.getGridHeight()), new NullPropagator(new ConstantPotential()));
    private boolean split = false;
    private double simulationTime = 0.0;

    public MandelModel() {
        this(100, 100);
    }

    public MandelModel(int n, int n2) {
        this(n, n2, 1.0E-5, MandelModel.createInitWave());
    }

    public MandelModel(int n, int n2, double d, Wave wave) {
        super(n, n2, d, wave);
        super.setBarrierAbsorptive(false);
        this.setDetectionCausesCollapse(false);
    }

    public void setPropagator(Propagator propagator) {
        super.setPropagator(propagator);
        this.leftWaveModel.setPropagator(propagator.copy());
        this.rightWaveModel.setPropagator(propagator.copy());
    }

    public double getSimulationTime() {
        return this.simulationTime;
    }

    protected void step() {
        this.beforeTimeStep();
        if (!this.split) {
            this.getWaveModel().propagate();
            this.getDamping().damp(this.getWavefunction());
        } else {
            this.leftWaveModel.propagate();
            this.rightWaveModel.propagate();
            this.getDamping().damp(this.leftWaveModel.getWavefunction());
            this.getDamping().damp(this.rightWaveModel.getWavefunction());
        }
        this.incrementTimeStep();
        this.simulationTime += this.getDeltaTime();
        this.finishedTimeStep();
    }

    public void clearAllWaves() {
        super.clearAllWaves();
        this.leftWaveModel.clear();
        this.rightWaveModel.clear();
    }

    public void reset() {
        super.reset();
        this.rightWaveModel.clear();
        this.leftWaveModel.clear();
    }

    public void clearWavefunction() {
        super.clearWavefunction();
        this.rightWaveModel.clear();
        this.leftWaveModel.clear();
    }

    public void setSplitMode(boolean bl) {
        this.split = bl;
    }

    public boolean isSplit() {
        return this.split;
    }

    public WaveModel getLeftWaveModel() {
        return this.leftWaveModel;
    }

    public WaveModel getRightWaveModel() {
        return this.rightWaveModel;
    }

    public void setWaveSize(int n, int n2) {
        super.setWaveSize(n, n2);
        this.rightWaveModel.setWaveSize(n, n2);
        this.leftWaveModel.setWaveSize(n, n2);
    }

    public Wavefunction getDetectionRegion(int n, int n2, int n3, int n4) {
        if (this.split) {
            Wavefunction wavefunction = this.getLeftWaveModel().getWavefunction().copyRegion(0, n2, n3, n4);
            Wavefunction wavefunction2 = this.getRightWaveModel().getWavefunction().copyRegion(0, n2, n3, n4);
            Wavefunction wavefunction3 = wavefunction.copy();
            for (int i = 0; i < wavefunction3.getWidth(); ++i) {
                for (int j = 0; j < wavefunction3.getHeight(); ++j) {
                    Complex complex = wavefunction.valueAt(i, j);
                    Complex complex2 = wavefunction2.valueAt(i, j);
                    wavefunction3.setValue(i, j, (complex.abs() + complex2.abs()) / 2.0, 0.0);
                }
            }
            return wavefunction3;
        }
        return this.getWavefunction().copyRegion(0, n2, n3, n4);
    }

    public void updateWavefunctionAfterDetection() {
    }
}

