/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.quantumwaveinterference.modules.mandel;

import edu.colorado.phet.common.phetcommon.view.VerticalLayoutPanel;
import edu.colorado.phet.common.piccolophet.PhetPNode;
import edu.colorado.phet.common.piccolophet.event.CursorHandler;
import edu.colorado.phet.common.piccolophet.util.PImageFactory;
import edu.colorado.phet.quantumwaveinterference.controls.IntensitySlider;
import edu.colorado.phet.quantumwaveinterference.controls.SRRWavelengthSlider;
import edu.colorado.phet.quantumwaveinterference.view.QWIPanel;
import edu.colorado.phet.quantumwaveinterference.view.gun.GunControlPanel;
import edu.colorado.phet.quantumwaveinterference.view.gun.OnOffCheckBox;
import edu.colorado.phet.quantumwaveinterference.view.gun.OnOffItem;
import edu.colorado.phet.quantumwaveinterference.view.gun.SRRWavelengthSliderComponent;
import edu.colorado.phet.quantumwaveinterference.view.piccolo.HorizontalWireConnector;
import edu.umd.cs.piccolo.PNode;
import edu.umd.cs.piccolo.nodes.PImage;
import edu.umd.cs.piccolox.pswing.PSwing;
import java.awt.Color;
import java.awt.Dimension;
import java.util.ArrayList;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class MandelGun
extends PhetPNode {
    private PImage pimage;
    private GunControlPanel gunControlPanel;
    private ArrayList listeners = new ArrayList();
    private IntensitySlider intensitySlider;
    private SRRWavelengthSlider wavelengthSliderGraphic;
    private boolean on = false;
    private OnOffCheckBox onOffCheckBox;
    private PSwing onGunGraphic;

    public MandelGun(String string, QWIPanel qWIPanel) {
        this.pimage = PImageFactory.create(string);
        this.addChild(this.pimage);
        this.gunControlPanel = new GunControlPanel(qWIPanel);
        this.intensitySlider = new IntensitySlider(Color.blue, IntensitySlider.HORIZONTAL, new Dimension(140, 30));
        this.intensitySlider.setValue(100);
        VerticalLayoutPanel verticalLayoutPanel = new VerticalLayoutPanel();
        verticalLayoutPanel.addFullWidth(this.intensitySlider);
        this.wavelengthSliderGraphic = new SRRWavelengthSlider(qWIPanel);
        final SRRWavelengthSliderComponent sRRWavelengthSliderComponent = new SRRWavelengthSliderComponent(this.wavelengthSliderGraphic);
        verticalLayoutPanel.addFullWidth(sRRWavelengthSliderComponent);
        this.gunControlPanel.setGunControls(verticalLayoutPanel);
        this.addChild(this.gunControlPanel.getPSwing());
        this.wavelengthSliderGraphic.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                sRRWavelengthSliderComponent.repaint();
            }
        });
        this.wavelengthSliderGraphic.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                MandelGun.this.updateSliderColor();
                MandelGun.this.fireColorChanged();
            }
        });
        this.updateSliderColor();
        this.intensitySlider.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                MandelGun.this.fireIntensityChanged();
            }
        });
        HorizontalWireConnector horizontalWireConnector = new HorizontalWireConnector(this.pimage, this.gunControlPanel.getPSwing());
        this.addChild(0, horizontalWireConnector);
        this.onOffCheckBox = new OnOffCheckBox(new OnOffItem(){

            public boolean isOn() {
                return MandelGun.this.on;
            }

            public void setOn(boolean bl) {
                MandelGun.this.on = bl;
                MandelGun.this.fireIntensityChanged();
            }
        });
        this.onGunGraphic = new PSwing(this.onOffCheckBox);
        this.onGunGraphic.addInputEventListener(new CursorHandler());
        this.addChild(this.onGunGraphic);
        this.onGunGraphic.setOffset(this.pimage.getFullBounds().getX() + this.pimage.getFullBounds().getWidth() / 2.0 - this.onGunGraphic.getFullBounds().getWidth() / 2.0 + -3.0, 77.0 + this.pimage.getFullBounds().getY());
    }

    private void fireColorChanged() {
        for (int i = 0; i < this.listeners.size(); ++i) {
            Listener listener = (Listener)this.listeners.get(i);
            listener.wavelengthChanged();
        }
    }

    private void fireIntensityChanged() {
        for (int i = 0; i < this.listeners.size(); ++i) {
            Listener listener = (Listener)this.listeners.get(i);
            listener.intensityChanged();
        }
    }

    private void updateSliderColor() {
        this.intensitySlider.setColor(this.wavelengthSliderGraphic.getVisibleColor());
    }

    public void setControlsOffset(double d, double d2) {
        this.gunControlPanel.getPSwing().setOffset(d, d2);
    }

    public PNode getGunControlPanelPSwing() {
        return this.gunControlPanel.getPSwing();
    }

    public PNode getGunImageGraphic() {
        return this.pimage;
    }

    public void setControlBackgroundColor(Color color) {
        this.onOffCheckBox.setBackground(color);
    }

    public void translateOnGunControls(int n, int n2) {
        this.onGunGraphic.translate(n, n2);
    }

    public double getWavelength() {
        return this.wavelengthSliderGraphic.getWavelength();
    }

    public double getIntensity() {
        return this.on ? (double)this.intensitySlider.getValue() / 100.0 : 0.0;
    }

    public double getMomentum() {
        return 1.0 / this.getWavelength();
    }

    public void setWavelength(double d) {
        this.wavelengthSliderGraphic.setWavelength(d);
    }

    public void addListener(Listener listener) {
        this.listeners.add(listener);
    }

    public static interface Listener {
        public void wavelengthChanged();

        public void intensityChanged();
    }
}

