/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.quantumwaveinterference.model.propagators;

import edu.colorado.phet.quantumwaveinterference.model.Potential;
import edu.colorado.phet.quantumwaveinterference.model.Propagator;
import edu.colorado.phet.quantumwaveinterference.model.Wavefunction;
import edu.colorado.phet.quantumwaveinterference.model.math.Complex;
import java.util.HashMap;
import java.util.Map;

public class RichardsonPropagator
extends Propagator {
    private double simulationTime;
    private int timeStep;
    private double hbar;
    private double mass;
    private double epsilon;
    private Complex alpha;
    private Complex beta;
    private Complex[][] betaeven;
    private Complex[][] betaodd;
    protected Wavefunction copy;
    Complex aTemp = new Complex();
    Complex bTemp = new Complex();
    Complex cTemp = new Complex();
    Complex potTemp = new Complex();
    Complex waveTemp = new Complex();

    public RichardsonPropagator(double d, Potential potential, double d2, double d3) {
        super(potential);
        this.setDeltaTime(d);
        this.setPotential(potential);
        this.simulationTime = 0.0;
        this.timeStep = 0;
        this.mass = d3;
        this.hbar = d2;
        this.betaeven = new Complex[0][0];
        this.betaodd = new Complex[0][0];
        this.update();
    }

    public Map getModelParameters() {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("deltaTime", "" + this.getDeltaTime());
        hashMap.put("propagator_mass", "" + this.mass);
        hashMap.put("hbar", "" + this.hbar);
        return hashMap;
    }

    public void setValue(int n, int n2, double d, double d2) {
    }

    public void update() {
        this.epsilon = this.hbar * this.getDeltaTime() / this.mass;
        this.alpha = this.createAlpha();
        this.beta = this.createBeta();
        if (this.betaeven == null) {
            return;
        }
        for (int i = 0; i < this.betaeven.length; ++i) {
            for (int j = 0; j < this.betaeven[i].length; ++j) {
                this.betaeven[i][j] = new Complex();
                this.betaodd[i][j] = new Complex();
                if ((i + j) % 2 == 0) {
                    this.betaeven[i][j] = this.beta;
                    continue;
                }
                this.betaodd[i][j] = this.beta;
            }
        }
    }

    protected Complex createAlpha() {
        return new Complex((1.0 + Math.cos(this.epsilon)) / 2.0, -Math.sin(this.epsilon) / 2.0);
    }

    protected Complex createBeta() {
        return new Complex((1.0 - Math.cos(this.epsilon)) / 2.0, Math.sin(this.epsilon) / 2.0);
    }

    public void propagate(Wavefunction wavefunction) {
        this.propagateOnce(wavefunction);
    }

    private void propagateOnce(Wavefunction wavefunction) {
        int n = wavefunction.getWidth();
        if (this.betaeven.length != wavefunction.getWidth()) {
            this.betaeven = new Complex[n][n];
            this.betaodd = new Complex[n][n];
            this.update();
        }
        this.prop2D(wavefunction);
        this.simulationTime += this.getDeltaTime();
        ++this.timeStep;
    }

    protected void prop2D(Wavefunction wavefunction) {
        this.copy = new Wavefunction(wavefunction.getWidth(), wavefunction.getHeight());
        this.applyPotential(wavefunction);
        this.stepIt(wavefunction, 0, -1);
        this.stepIt(wavefunction, 0, 1);
        this.stepIt(wavefunction, 1, 0);
        this.stepIt(wavefunction, -1, 0);
    }

    protected void stepIt(Wavefunction wavefunction, int n, int n2) {
        int n3;
        wavefunction.copyTo(this.copy);
        for (n3 = 1; n3 < wavefunction.getWidth() - 1; ++n3) {
            for (int i = 1; i < wavefunction.getHeight() - 1; ++i) {
                this.stepIt(wavefunction, n3, i, n, n2);
            }
        }
        for (n3 = 0; n3 < wavefunction.getWidth(); ++n3) {
            this.stepItConstrained(wavefunction, n3, 0, n, n2);
            this.stepItConstrained(wavefunction, n3, wavefunction.getHeight() - 1, n, n2);
        }
        for (n3 = 1; n3 < wavefunction.getHeight(); ++n3) {
            this.stepItConstrained(wavefunction, 0, n3, n, n2);
            this.stepItConstrained(wavefunction, wavefunction.getWidth() - 1, n3, n, n2);
        }
    }

    private void stepItConstrained(Wavefunction wavefunction, int n, int n2, int n3, int n4) {
        int n5 = (n + n3 + wavefunction.getWidth()) % wavefunction.getWidth();
        int n6 = (n2 + n4 + wavefunction.getHeight()) % wavefunction.getHeight();
        int n7 = (n - n3 + wavefunction.getWidth()) % wavefunction.getWidth();
        int n8 = (n2 - n4 + wavefunction.getHeight()) % wavefunction.getHeight();
        this.aTemp.setToProduct(this.alpha, this.copy.valueAt(n, n2));
        this.bTemp.setToProduct(this.betaeven[n][n2], this.copy.valueAt(n5, n6));
        this.cTemp.setToProduct(this.betaodd[n][n2], this.copy.valueAt(n7, n8));
        wavefunction.valueAt(n, n2).setToSum(this.aTemp, this.bTemp, this.cTemp);
    }

    private void stepIt(Wavefunction wavefunction, int n, int n2, int n3, int n4) {
        boolean bl;
        boolean bl2 = bl = (n + n2) % 2 == 0;
        if (bl) {
            this.aTemp.setToProduct(this.alpha, this.copy.valueAt(n, n2));
            this.bTemp.setToProduct(this.betaeven[n][n2], this.copy.valueAt(n + n3, n2 + n4));
            wavefunction.valueAt(n, n2).setToSum(this.aTemp, this.bTemp);
        } else {
            this.aTemp.setToProduct(this.alpha, this.copy.valueAt(n, n2));
            this.cTemp.setToProduct(this.betaodd[n][n2], this.copy.valueAt(n - n3, n2 - n4));
            wavefunction.valueAt(n, n2).setToSum(this.aTemp, this.cTemp);
        }
    }

    protected void applyPotential(Wavefunction wavefunction) {
        for (int i = 1; i < wavefunction.getWidth() - 1; ++i) {
            for (int j = 1; j < wavefunction.getHeight() - 1; ++j) {
                double d = this.getPotential().getPotential(i, j, this.timeStep);
                if (!(d > 10.0)) continue;
                wavefunction.valueAt(i, j).setValue(0.0, 0.0);
            }
        }
    }

    public void setDeltaTime(double d) {
        super.setDeltaTime(d);
        this.update();
    }

    public double getSimulationTime() {
        return this.simulationTime;
    }

    public void reset() {
    }

    public Propagator copy() {
        return new RichardsonPropagator(this.getDeltaTime(), this.getPotential(), this.getHBar(), this.getMass());
    }

    public void setWavefunctionNorm(double d) {
    }

    public double getEpsilon() {
        return this.epsilon;
    }

    public double getHBar() {
        return this.hbar;
    }

    public double getMass() {
        return this.mass;
    }
}

