/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.quantumwaveinterference.model;

import edu.colorado.phet.quantumwaveinterference.model.Detector;
import edu.colorado.phet.quantumwaveinterference.model.Propagator;
import edu.colorado.phet.quantumwaveinterference.model.QWIModel;
import edu.colorado.phet.quantumwaveinterference.model.Wave;
import edu.colorado.phet.quantumwaveinterference.model.WaveModel;
import edu.colorado.phet.quantumwaveinterference.model.Wavefunction;
import edu.colorado.phet.quantumwaveinterference.model.math.Complex;
import edu.colorado.phet.quantumwaveinterference.model.potentials.ConstantPotential;
import edu.colorado.phet.quantumwaveinterference.model.potentials.HorizontalDoubleSlit;
import edu.colorado.phet.quantumwaveinterference.model.propagators.NullPropagator;
import edu.colorado.phet.quantumwaveinterference.view.piccolo.detectorscreen.IntensityManager;
import java.awt.Rectangle;

public class SplitModel
extends QWIModel {
    private WaveModel rightWaveModel;
    private WaveModel leftWaveModel;
    private Detector leftDetector;
    private Detector rightDetector;
    private Mode mode = new NormalMode();
    private HorizontalDoubleSlit.Listener listener;

    public SplitModel() {
        this(100, 100);
    }

    public SplitModel(int n, int n2) {
        this(n, n2, 1.0E-5, SplitModel.createInitWave());
    }

    public SplitModel(int n, int n2, double d, Wave wave) {
        super(n, n2, d, wave);
        this.rightWaveModel = new WaveModel(new Wavefunction(this.getGridWidth(), this.getGridHeight()), new NullPropagator(new ConstantPotential()));
        this.leftWaveModel = new WaveModel(new Wavefunction(this.getGridWidth(), this.getGridHeight()), new NullPropagator(new ConstantPotential()));
        this.leftDetector = new Detector(this, 0, 0, 0, 0);
        this.rightDetector = new Detector(this, 0, 0, 0, 0);
        this.listener = new HorizontalDoubleSlit.Listener(){

            public void slitChanged() {
                SplitModel.this.synchronizeDetectorRegions();
            }
        };
        this.getDoubleSlitPotential().addListener(this.listener);
        this.synchronizeDetectorRegions();
        this.setDetectionCausesCollapse(false);
    }

    public void synchronizeDetectorRegions() {
        Rectangle[] rectangleArray = this.getDoubleSlitPotential().getSlitAreas();
        this.leftDetector.setRect(rectangleArray[0]);
        this.rightDetector.setRect(rectangleArray[1]);
    }

    public Wavefunction getDetectionRegion(int n, int n2, int n3, int n4) {
        return this.mode.getDetectionRegion(n, n2, n3, n4);
    }

    public void setPropagator(Propagator propagator) {
        super.setPropagator(propagator);
        this.leftWaveModel.setPropagator(propagator.copy());
        this.rightWaveModel.setPropagator(propagator.copy());
    }

    protected void step() {
        this.mode.step();
    }

    public void reset() {
        super.reset();
        this.rightWaveModel.clear();
        this.leftWaveModel.clear();
    }

    public void clearWavefunction() {
        super.clearWavefunction();
        this.rightWaveModel.clear();
        this.leftWaveModel.clear();
    }

    public Wavefunction getRightWavefunction() {
        return this.rightWaveModel.getWavefunction();
    }

    public Wavefunction getLeftWavefunction() {
        return this.leftWaveModel.getWavefunction();
    }

    public Detector getLeftDetector() {
        return this.leftDetector;
    }

    public Detector getRightDetector() {
        return this.rightDetector;
    }

    public void setSplitMode(boolean bl) {
        Mode mode = this.mode = bl ? new SplitMode() : new NormalMode();
        if (bl) {
            this.copyNorthRegionToLR();
        } else {
            this.copyLRToNorthRegion();
        }
    }

    private void copyLRToNorthRegion() {
        this.getWaveModel().combineWaves(this.getNorthRegion(), this.leftWaveModel, this.rightWaveModel);
    }

    public Rectangle getNorthRegion() {
        return new Rectangle(0, 0, this.getLeftWavefunction().getWidth(), this.getDoubleSlitPotential().getY());
    }

    private void copyNorthRegionToLR() {
        this.getWaveModel().splitWave(this.getNorthRegion(), this.leftWaveModel, this.rightWaveModel);
    }

    private Wavefunction superGetDetectionRegion(int n, int n2, int n3, int n4) {
        return super.getDetectionRegion(n, n2, n3, n4);
    }

    private void superStep() {
        super.step();
    }

    private void finishStep() {
        this.getWaveModel().clearWave(new Rectangle(this.getWavefunction().getWidth(), this.getSlitTopY()));
        this.rightWaveModel.propagate();
        this.leftWaveModel.propagate();
        this.getDamping().damp(this.getRightWavefunction());
        this.getDamping().damp(this.getLeftWavefunction());
        this.clearLRWavesSouthArea();
        this.incrementTimeStep();
        this.finishedTimeStep();
    }

    private void clearLRWavesSouthArea() {
        Rectangle rectangle = this.getLRWaveSouthClearArea();
        this.leftWaveModel.clearWave(rectangle);
        this.rightWaveModel.clearWave(rectangle);
    }

    protected Rectangle getLRWaveSouthClearArea() {
        int n = (int)this.getDoubleSlitPotential().getSlitAreas()[0].getMaxY();
        return new Rectangle(0, n, this.getLeftWavefunction().getWidth(), this.getLeftWavefunction().getHeight());
    }

    protected int getSlitTopY() {
        return (int)this.getDoubleSlitPotential().getSlitAreas()[0].getMinY();
    }

    public static Wavefunction sumMagnitudes(Wavefunction wavefunction, Wavefunction wavefunction2) {
        Wavefunction wavefunction3 = wavefunction.createEmptyWavefunction();
        for (int i = 0; i < wavefunction3.getWidth(); ++i) {
            for (int j = 0; j < wavefunction3.getHeight(); ++j) {
                Complex complex = wavefunction.valueAt(i, j);
                Complex complex2 = wavefunction2.valueAt(i, j);
                double d = SplitModel.sumMagnitudes(complex, complex2);
                wavefunction3.setValue(i, j, new Complex(d, 0.0));
            }
        }
        return wavefunction3;
    }

    public static double sumMagnitudes(Complex complex, Complex complex2) {
        double d = complex.abs();
        double d2 = complex2.abs();
        return d + d2;
    }

    public void updateWavefunctionAfterDetection() {
        this.reduceWavefunctionNorm(IntensityManager.NORM_DECREMENT);
    }

    public void setWaveSize(int n, int n2) {
        super.setWaveSize(n, n2);
        this.rightWaveModel.setWaveSize(n, n2);
        this.leftWaveModel.setWaveSize(n, n2);
    }

    static interface Mode {
        public Wavefunction getDetectionRegion(int var1, int var2, int var3, int var4);

        public void step();
    }

    class NormalMode
    implements Mode {
        NormalMode() {
        }

        public Wavefunction getDetectionRegion(int n, int n2, int n3, int n4) {
            return SplitModel.this.superGetDetectionRegion(n, n2, n3, n4);
        }

        public void step() {
            SplitModel.this.superStep();
            SplitModel.this.clearLRWavesSouthArea();
        }
    }

    class SplitMode
    implements Mode {
        SplitMode() {
        }

        public Wavefunction getDetectionRegion(int n, int n2, int n3, int n4) {
            Wavefunction wavefunction = SplitModel.this.getLeftWavefunction().copyRegion(0, n2, n3, n4);
            Wavefunction wavefunction2 = SplitModel.this.getRightWavefunction().copyRegion(0, n2, n3, n4);
            return SplitModel.sumMagnitudes(wavefunction, wavefunction2);
        }

        public void step() {
            if (SplitModel.this.isBarrierAbsorptive()) {
                SplitModel.this.beforeTimeStep();
                SplitModel.this.getPropagationStrategy().step();
                Rectangle[] rectangleArray = SplitModel.this.getDoubleSlitPotential().getSlitAreas();
                SplitModel.this.getSourceWaveModel().copyTo(this.deepen(rectangleArray[0]), SplitModel.this.leftWaveModel);
                SplitModel.this.getSourceWaveModel().copyTo(this.deepen(rectangleArray[1]), SplitModel.this.rightWaveModel);
                SplitModel.this.finishStep();
            } else {
                SplitModel.this.beforeTimeStep();
                SplitModel.this.getPropagationStrategy().step();
                Rectangle[] rectangleArray = SplitModel.this.getDoubleSlitPotential().getSlitAreas();
                SplitModel.this.getWaveModel().copyTo(rectangleArray[0], SplitModel.this.leftWaveModel);
                SplitModel.this.getWaveModel().copyTo(rectangleArray[1], SplitModel.this.rightWaveModel);
                SplitModel.this.finishStep();
            }
        }

        private Rectangle deepen(Rectangle rectangle) {
            return new Rectangle(rectangle.x, rectangle.y, rectangle.width, rectangle.height + 2);
        }
    }
}

