/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.quantumwaveinterference.model;

import edu.colorado.phet.common.phetcommon.util.SimpleObservable;
import edu.colorado.phet.quantumwaveinterference.model.QWIModel;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;

public class RectangularObject
extends SimpleObservable {
    private QWIModel QWIModel;
    private int x;
    private int y;
    private int width;
    private int height;
    private FractionalSize fractionalSize = new FractionalSize();

    public RectangularObject(final QWIModel qWIModel, int n, int n2, int n3, int n4) {
        this.QWIModel = qWIModel;
        this.x = n;
        this.y = n2;
        this.width = n3;
        this.height = n4;
        qWIModel.addListener(new QWIModel.Adapter(){

            public void sizeChanged() {
                Rectangle rectangle = RectangularObject.this.fractionalSize.getBounds(qWIModel.getWavefunction().getWidth(), qWIModel.getWavefunction().getHeight());
                RectangularObject.this.setBoundsInternal(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
            }
        });
        this.updateFractionalSize();
    }

    private void updateFractionalSize() {
        this.fractionalSize.update(this.getBounds(), this.QWIModel.getWavefunction().getWidth(), this.QWIModel.getWavefunction().getHeight());
    }

    public Rectangle getBounds() {
        return new Rectangle(this.x, this.y, this.width, this.height);
    }

    private void setBoundsInternal(int n, int n2, int n3, int n4) {
        this.x = n;
        this.y = n2;
        this.width = n3;
        this.height = n4;
        this.notifyObservers();
    }

    public void setLocation(int n, int n2) {
        this.x = n;
        this.y = n2;
        this.updateFractionalSize();
        this.notifyObservers();
    }

    public void setSize(int n, int n2) {
        this.width = n;
        this.height = n2;
        this.updateFractionalSize();
        this.notifyObservers();
    }

    public Point getLocation() {
        return new Point(this.x, this.y);
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public Dimension getDimension() {
        return new Dimension(this.width, this.height);
    }

    public int getX() {
        return this.x;
    }

    public int getY() {
        return this.y;
    }

    static class FractionalSize {
        double x;
        double y;
        double width;
        double height;

        FractionalSize() {
        }

        public void update(Rectangle rectangle, int n, int n2) {
            this.x = (double)rectangle.x / (double)n;
            this.y = (double)rectangle.y / (double)n2;
            this.width = (double)rectangle.width / (double)n;
            this.height = (double)rectangle.height / (double)n2;
        }

        public Rectangle getBounds(int n, int n2) {
            return new Rectangle((int)(this.x * (double)n), (int)(this.y * (double)n2), (int)(this.width * (double)n), (int)(this.height * (double)n2));
        }
    }
}

