/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.quantumwaveinterference.model;

import edu.colorado.phet.quantumwaveinterference.model.Wave;
import edu.colorado.phet.quantumwaveinterference.model.WaveModel;
import edu.colorado.phet.quantumwaveinterference.model.math.Complex;
import java.awt.Rectangle;
import java.awt.geom.Rectangle2D;

public class CylinderSource {
    private Rectangle region;
    private Wave wave;
    private Rectangle2D.Double ellipse;

    public CylinderSource(Rectangle rectangle, Wave wave) {
        this.setRegion(rectangle);
        this.wave = wave;
    }

    public void initializeEntrantWave(WaveModel waveModel, double d) {
        for (int i = this.region.x; i < this.region.x + this.region.width; ++i) {
            for (int j = this.region.y; j < this.region.y + this.region.height; ++j) {
                if (!this.ellipse.contains(i, j) || !waveModel.containsLocation(i, j)) continue;
                Complex complex = this.wave.getValue(i, j, d);
                waveModel.setValue(i, j, complex.real, complex.imag);
            }
        }
    }

    public void setRegion(Rectangle rectangle) {
        this.region = rectangle;
        this.ellipse = new Rectangle2D.Double(this.region.getX(), this.region.getY(), this.region.getWidth(), this.region.getHeight());
    }

    public void setWave(Wave wave) {
        this.wave = wave;
    }
}

