/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.quantumwaveinterference.davissongermer;

import edu.colorado.phet.common.piccolophet.PhetPNode;
import edu.umd.cs.piccolo.PNode;
import edu.umd.cs.piccolo.nodes.PPath;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.GradientPaint;
import java.awt.geom.Rectangle2D;

public class ProtractorHandleGraphic
extends PhetPNode {
    private Tip tip;
    private Body body;
    private Base base;
    private int bodyWidth = 14;
    private int bodyHeight = 120;
    private int tipWidth = 16;
    private float tipHeight = 40.0f;
    private int baseHeight = 10;
    private int baseWidth = this.bodyWidth + 4;

    public ProtractorHandleGraphic() {
        this.tip = new Tip();
        this.body = new Body();
        this.base = new Base();
        this.addChild(this.body);
        this.addChild(this.base);
        this.addChild(this.tip);
    }

    class Base
    extends PNode {
        private PPath path = new PPath();

        public Base() {
            Rectangle2D.Double double_ = new Rectangle2D.Double(-ProtractorHandleGraphic.this.baseWidth / 2, ProtractorHandleGraphic.this.body.getFullBounds().getMaxY(), ProtractorHandleGraphic.this.baseWidth, ProtractorHandleGraphic.this.baseHeight);
            this.path.setPathTo(double_);
            this.path.setPaint(new GradientPaint((float)double_.getX(), (float)double_.getY(), Color.blue, (float)double_.getMaxX(), (float)double_.getMaxY(), Color.white, true));
            this.path.setStroke(new BasicStroke(2.0f, 1, 1));
            this.path.setStrokePaint(new GradientPaint((float)double_.getX(), (float)double_.getY(), Color.gray, (float)double_.getMaxX(), (float)double_.getMaxY(), Color.black, true));
            this.addChild(this.path);
        }
    }

    class Body
    extends PNode {
        private PPath path = new PPath();

        public Body() {
            Rectangle2D.Double double_ = new Rectangle2D.Double(-ProtractorHandleGraphic.this.bodyWidth / 2, ProtractorHandleGraphic.this.tipHeight, ProtractorHandleGraphic.this.bodyWidth, ProtractorHandleGraphic.this.bodyHeight);
            this.path.setPathTo(double_);
            this.path.setPaint(new GradientPaint((float)double_.getX(), (float)double_.getY(), Color.gray, (float)double_.getMaxX(), (float)double_.getMaxY(), Color.blue, true));
            this.addChild(this.path);
        }
    }

    class Tip
    extends PNode {
        private PPath path = new PPath();

        public Tip() {
            this.path.moveTo(0.0f, 0.0f);
            this.path.lineTo(ProtractorHandleGraphic.this.tipWidth / 2, ProtractorHandleGraphic.this.tipHeight);
            this.path.lineTo(-ProtractorHandleGraphic.this.tipWidth / 2, ProtractorHandleGraphic.this.tipHeight);
            this.path.lineTo(0.0f, 0.0f);
            this.path.setPaint(new GradientPaint(0.0f, 0.0f, Color.lightGray, ProtractorHandleGraphic.this.tipWidth / 2, 0.0f, Color.darkGray, true));
            this.addChild(this.path);
        }
    }
}

