/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.quantumwaveinterference.davissongermer;

import edu.colorado.phet.quantumwaveinterference.davissongermer.AtomPotential;
import edu.colorado.phet.quantumwaveinterference.davissongermer.ConcreteAtomLattice;
import java.awt.Point;

public abstract class FractionalAtomLattice {
    private double spacingBetweenAtoms;
    private double potential;
    private double atomRadius;
    private double y0;

    public FractionalAtomLattice(double d, double d2, double d3, double d4) {
        this.atomRadius = d;
        this.spacingBetweenAtoms = d2;
        this.y0 = d3;
        this.potential = d4;
    }

    public double getSpacingBetweenAtoms() {
        return this.spacingBetweenAtoms;
    }

    public void setSpacing(double d) {
        this.spacingBetweenAtoms = d;
    }

    public double getAtomRadius() {
        return this.atomRadius;
    }

    public void setAtomRadius(double d) {
        this.atomRadius = d;
    }

    public ConcreteAtomLattice toConcreteAtomLattice(int n, int n2) {
        int n3;
        int n4;
        int n5 = this.getConcreteAtomDiameter(n, n2);
        int n6 = this.getConcreteSpacing(n, n2);
        ConcreteAtomLattice concreteAtomLattice = new ConcreteAtomLattice(n, n2);
        int n7 = this.getConcreteY0(n2);
        for (n4 = n / 2; n4 <= n; n4 += n6) {
            for (n3 = n7; n3 >= 0; n3 -= n6) {
                this.addAtom(n4, n3, n5, concreteAtomLattice);
            }
        }
        for (n4 = n / 2 - n6; n4 >= 0; n4 -= n6) {
            for (n3 = n7; n3 >= 0; n3 -= n6) {
                this.addAtom(n4, n3, n5, concreteAtomLattice);
            }
        }
        concreteAtomLattice.setHeadAtom(n / 2, n7);
        concreteAtomLattice.updateAll();
        return concreteAtomLattice;
    }

    private int getConcreteY0(int n) {
        return (int)(this.y0 * (double)n);
    }

    public Point getCenterAtomConcretePoint(int n, int n2) {
        return new Point(n / 2, this.getConcreteY0(n2));
    }

    private void addAtom(int n, int n2, int n3, ConcreteAtomLattice concreteAtomLattice) {
        Point point = new Point(n, n2);
        AtomPotential atomPotential = this.createPotential(point, n3, this.potential);
        concreteAtomLattice.addAtomPotentialNoUpdate(atomPotential);
    }

    protected abstract AtomPotential createPotential(Point var1, int var2, double var3);

    private int getConcreteSpacing(int n, int n2) {
        return this.round(this.spacingBetweenAtoms * (double)n);
    }

    private int getConcreteAtomDiameter(int n, int n2) {
        return this.round2(this.atomRadius * (double)n * 2.0);
    }

    private int round2(double d) {
        return (int)Math.round(d);
    }

    private int round(double d) {
        return (int)d;
    }
}

